/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.model.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateLoader {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject loadTemplate(String template) {
        try (InputStream input = TemplateLoader.class.getResourceAsStream("/assets/betterblockentities/models/block/templates/" + template);){
            if (input == null) {
                JsonObject jsonObject2 = null;
                return jsonObject2;
            }
            JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(input, StandardCharsets.UTF_8)).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ElementRecord> readTemplateElements(JsonObject templateRoot) {
        ArrayList<ElementRecord> elements = new ArrayList<ElementRecord>();
        JsonArray arr = templateRoot.getAsJsonArray("elements");
        if (arr == null) {
            return elements;
        }
        for (JsonElement el : arr) {
            JsonObject obj = el.getAsJsonObject();
            List<Float> from = this.jsonArrayToFloatList(obj.getAsJsonArray("from"));
            List<Float> to = this.jsonArrayToFloatList(obj.getAsJsonArray("to"));
            Map<String, FaceRecord> faces = this.readFaces(obj.getAsJsonObject("faces"));
            RotationRecord rotation = null;
            if (obj.has("rotation")) {
                JsonObject rotObj = obj.getAsJsonObject("rotation");
                List<Float> origin = rotObj.has("origin") ? this.jsonArrayToFloatList(rotObj.getAsJsonArray("origin")) : List.of(Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f));
                String axis = rotObj.has("axis") ? rotObj.get("axis").getAsString() : "y";
                float angle = rotObj.has("angle") ? rotObj.get("angle").getAsFloat() : 0.0f;
                boolean rescale = rotObj.has("rescale") && rotObj.get("rescale").getAsBoolean();
                rotation = new RotationRecord(origin, axis, angle, rescale);
            }
            elements.add(new ElementRecord(from, to, faces, rotation));
        }
        return elements;
    }

    private Map<String, FaceRecord> readFaces(JsonObject faces) {
        HashMap<String, FaceRecord> map = new HashMap<String, FaceRecord>();
        for (String face : faces.keySet()) {
            JsonObject faceData = faces.getAsJsonObject(face);
            List<Float> uv = faceData.has("uv") ? this.jsonArrayToFloatList(faceData.getAsJsonArray("uv")) : List.of();
            String texture = faceData.has("texture") ? faceData.get("texture").getAsString() : "";
            Float rotation = faceData.has("rotation") ? Float.valueOf(faceData.get("rotation").getAsFloat()) : null;
            map.put(face, new FaceRecord(uv, texture, rotation));
        }
        return map;
    }

    private List<Float> jsonArrayToFloatList(JsonArray arr) {
        ArrayList<Float> list = new ArrayList<Float>();
        if (arr == null) {
            return list;
        }
        for (JsonElement e : arr) {
            list.add(Float.valueOf(e.getAsFloat()));
        }
        return list;
    }

    public record RotationRecord(List<Float> origin, String axis, float angle, boolean rescale) {
    }

    public record ElementRecord(List<Float> from, List<Float> to, Map<String, FaceRecord> faces, RotationRecord rotation) {
    }

    public record FaceRecord(List<Float> uv, String texture, Float rotation) {
    }
}

