package betterblockentities.mixin.minecraft.sign;

/* local */
import betterblockentities.gui.ConfigManager;
import net.minecraft.class_10529;
import net.minecraft.class_11659;
import net.minecraft.class_11971;
import net.minecraft.class_12075;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/*
    this whole mixin will probably get removed once we move to baking the sign text into meshes
    as this implementation is not as efficient
*/
@Mixin(class_10529.class)
public abstract class AbstractSignBlockEntityRendererMixin {
    @Shadow protected abstract void applyTransforms(class_4587 matrices, float blockRotationDegrees, class_2680 state);
    @Shadow protected abstract void renderText(class_11971 renderState, class_4587 matrices, class_11659 queue, boolean front);

    @Inject(method = "render(Lnet/minecraft/client/render/block/entity/state/SignBlockEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;Lnet/minecraft/client/render/state/CameraRenderState;)V", at = @At("HEAD"), cancellable = true)
    public void render(class_11971 state, class_4587 matrixStack, class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState, CallbackInfo ci) {
        if (!ConfigManager.CONFIG.optimize_signs || !ConfigManager.CONFIG.master_optimize) return;

        ci.cancel();

        /* sanity check */
        if (state.field_62739 == null || state.field_62740 == null) return;

        /* check if we have text */
        boolean hasTextFront = hasText(state.field_62739.method_49877(false));
        boolean hasTextBack = hasText(state.field_62740.method_49877(false));

        /* if no text then don't render */
        if (!hasTextFront && !hasTextBack) return;

        class_2680 blockState = state.field_62674;
        class_2478 block = (class_2478) blockState.method_26204();

        matrixStack.method_22903();
        this.applyTransforms(matrixStack, -block.method_49814(blockState), blockState);

        if (hasTextFront) this.renderText(state, matrixStack, orderedRenderCommandQueue, true);
        if (hasTextBack)  this.renderText(state, matrixStack, orderedRenderCommandQueue, false);

        matrixStack.method_22909();
    }

    @Unique
    private boolean hasText(class_2561[] lines) {
        for (class_2561 line : lines) {
            if (line != null && !line.getString().isEmpty()) return true;
        }
        return false;
    }
}
