package betterblockentities.mixin.sodium;

/* sodium */
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractBlockRenderContext;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;

/* fabric */
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

/* java/misc */
import org.jetbrains.annotations.Nullable;

@Pseudo
@Mixin(AbstractBlockRenderContext.class)
public interface AbstractBlockRenderContextAccessor
{
    @Accessor("level")
    class_1920 getLevel();

    @Accessor("random")
    class_5819 getRandom();

    @Accessor("defaultRenderType")
    class_11515 getDefaultRenderType();

    @Accessor("defaultRenderType")
    void setDefaultRenderType(@Nullable class_11515 layer);

    @Accessor("state")
    class_2680 getState();
    @Accessor("state")
    void setState(class_2680 state);

    @Accessor("pos")
    class_2338 getPos();
    @Accessor("pos")
    void setPos(class_2338 pos);

    @Accessor("allowDowngrade")
    boolean getAllowDowngrade();
    @Accessor("allowDowngrade")
    void setAllowDowngrade(boolean allow);

    @Accessor("slice")
    LevelSlice getSlice();
    @Accessor("slice")
    void setSlice(LevelSlice slice);

    @Invoker("getEmitter")
    QuadEmitter getEmitterInvoke();

    @Invoker("prepareAoInfo")
    void prepareAoInfoInvoke(boolean modelAo);

    @Invoker("prepareCulling")
    void prepareCullingInvoke(boolean enableCulling);

    @Invoker("isFaceCulled")
    boolean isFaceCulledInvoke(@Nullable class_2350 face);
}