package betterblockentities.mixin.sodium;

/* local */
import betterblockentities.util.BlockEntityManager;

/* sodium */
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;

/* minecraft */
import net.minecraft.block.entity.*;
import net.minecraft.class_11658;
import net.minecraft.class_2586;
import net.minecraft.class_3191;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.client.render.*;
/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/* java/misc */
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.SortedSet;

@Pseudo
@Mixin(SodiumWorldRenderer.class)
public abstract class SodiumWorldRendererMixin
{
    @Inject(method = "extractBlockEntity", at = @At("HEAD"), cancellable = true)
    private void extractBlockEntity(class_2586 blockEntity, class_4587 poseStack, class_4184 camera, float tickDelta, Long2ObjectMap<SortedSet<class_3191>> progression, class_11658 levelRenderState, CallbackInfo ci) {
        if (!BlockEntityManager.shouldRender(blockEntity))
            ci.cancel();
    }
}