package betterblockentities.resource.pack;

/* gson */
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
/* minecraft */
import net.minecraft.resource.*;
/* java/misc */
import org.jetbrains.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Pack implements class_3262 {
    private final String name;
    private final byte[] packData;
    private final Map<String, byte[]> entries = new HashMap<>();
    private final Map<class_3264, Set<String>> namespaces = new EnumMap<>(class_3264.class);

    public Pack(String name, byte[] packData) {
        this.name = name;
        this.packData = packData;
        buildCache();
    }

    private void buildCache() {
        try (ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(packData))) {
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    byte[] data = zip.readAllBytes();
                    entries.put(entry.getName(), data);

                    // Track namespaces for each type
                    for (class_3264 type : class_3264.values()) {
                        String dir = type.method_14413() + "/";
                        if (entry.getName().startsWith(dir)) {
                            String rest = entry.getName().substring(dir.length());
                            String namespace = rest.split("/", 2)[0];
                            namespaces.computeIfAbsent(type, t -> new HashSet<>()).add(namespace);
                        }
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public @Nullable class_7367<InputStream> method_14410(String... segments) {
        String path = String.join("/", segments);
        byte[] data = entries.get(path);
        return data == null ? null : () -> new ByteArrayInputStream(data);
    }

    @Override
    public @Nullable class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        String path = type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832();
        byte[] data = entries.get(path);
        return data == null ? null : () -> new ByteArrayInputStream(data);
    }

    @Override
    public void method_14408(class_3264 type, String namespace, String prefix, class_7664 consumer) {
        String base = type.method_14413() + "/" + namespace + "/" + prefix;
        entries.forEach((path, data) -> {
            if (path.startsWith(base)) {
                String relative = path.substring(type.method_14413().length() + 1 + namespace.length() + 1);
                consumer.accept(class_2960.method_60655(namespace, relative), () -> new ByteArrayInputStream(data));
            }
        });
    }

    @Override
    public Set<String> method_14406(class_3264 type) {
        return namespaces.getOrDefault(type, Collections.emptySet());
    }

    @Override
    public @Nullable <T> T method_14407(class_7677<T> metadataSerializer) throws IOException {
        class_7367<InputStream> input = method_14410("pack.mcmeta");
        if (input == null) return null;
        try (InputStream stream = input.get()) {
            JsonObject json = JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject();
            if (!json.has(metadataSerializer.comp_3436())) return null;
            JsonElement section = json.get(metadataSerializer.comp_3436());
            return metadataSerializer.comp_3437().parse(JsonOps.INSTANCE, section).result().orElse(null);
        }
    }

    @Override
    public class_9224 method_56926() {
        return new class_9224(name, class_2561.method_43470("BBE-generated"), class_5352.field_25348, Optional.empty());
    }

    @Override
    public void close() {}
}
