/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.model.models;

import betterblockentities.resource.model.ModelGenerator;
import betterblockentities.resource.model.util.TemplateLoader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class SignModels
extends ModelGenerator {
    private static final List<String> WOOD_TYPES = List.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped", "pale_oak");

    public static class BlockState {
        public static void generateSignBlockstates(Map<String, byte[]> map) {
            for (String wood : WOOD_TYPES) {
                BlockState.generateBlockstate(map, wood, false, true);
                BlockState.generateBlockstate(map, wood, false, false);
                BlockState.generateBlockstate(map, wood, true, false);
                BlockState.generateBlockstate(map, wood, true, true);
            }
        }

        private static void generateBlockstate(Map<String, byte[]> map, String wood, boolean hanging, boolean wall) {
            String baseName = hanging && wall ? wood + "_wall_hanging_sign" : (hanging ? wood + "_hanging_sign" : (wall ? wood + "_wall_sign" : wood + "_sign"));
            JsonObject variants = new JsonObject();
            if (hanging && !wall) {
                for (int rot = 0; rot < 16; ++rot) {
                    JsonObject detachedVariant = new JsonObject();
                    detachedVariant.addProperty("model", "minecraft:block/" + baseName);
                    detachedVariant.addProperty("rotation", (Number)rot);
                    variants.add("attached=false,rotation=" + rot, (JsonElement)detachedVariant);
                    JsonObject attachedVariant = new JsonObject();
                    attachedVariant.addProperty("model", "minecraft:block/" + baseName + "_attached");
                    attachedVariant.addProperty("rotation", (Number)rot);
                    variants.add("attached=true,rotation=" + rot, (JsonElement)attachedVariant);
                }
            } else if (wall) {
                String[] facings = new String[]{"north", "east", "south", "west"};
                int[] rotations = new int[]{0, 90, 180, 270};
                for (int i = 0; i < facings.length; ++i) {
                    variants.add("facing=" + facings[i], (JsonElement)SignModels.createVariant(baseName, 0, rotations[i]));
                }
            } else {
                for (int rot = 0; rot < 16; ++rot) {
                    JsonObject variant = new JsonObject();
                    variant.addProperty("model", "minecraft:block/" + baseName);
                    variants.add("rotation=" + rot, (JsonElement)variant);
                }
            }
            JsonObject root = new JsonObject();
            root.add("variants", (JsonElement)variants);
            map.put("assets/minecraft/blockstates/" + baseName + ".json", GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
        }
    }

    public static class Model {
        private static String getParticleTexture(String woodtype) {
            return "minecraft:block/" + woodtype + "_planks";
        }

        public static void generateSignModels(Map<String, byte[]> map) {
            Model.generateSigns(map, "sign_template.json", false, true);
            Model.generateSigns(map, "sign_wall_template.json", false, false);
            Model.generateSigns(map, "sign_hanging_template.json", true, false);
            Model.generateSigns(map, "sign_hanging_wall_template.json", true, true);
            Model.generateAttachedHangingSigns(map);
        }

        private static void generateSigns(Map<String, byte[]> map, String templateName, boolean hanging, boolean standing) {
            JsonObject template = loader.loadTemplate(templateName);
            if (template == null) {
                return;
            }
            List<TemplateLoader.ElementRecord> elements = loader.readTemplateElements(template);
            for (String wood : WOOD_TYPES) {
                String texture = "minecraft:entity/signs/" + (hanging ? "hanging/" : "") + wood;
                String modelName = hanging && templateName.contains("wall") ? wood + "_wall_hanging_sign" : (hanging ? wood + "_hanging_sign" : (!standing ? wood + "_wall_sign" : wood + "_sign"));
                map.put("assets/minecraft/models/block/" + modelName + ".json", GSON.toJson((JsonElement)SignModels.makeModelWithParticle("sign", texture, Model.getParticleTexture(wood), elements)).getBytes(StandardCharsets.UTF_8));
            }
        }

        private static void generateAttachedHangingSigns(Map<String, byte[]> map) {
            JsonObject template = loader.loadTemplate("sign_hanging_attached_template.json");
            if (template == null) {
                return;
            }
            List<TemplateLoader.ElementRecord> elements = loader.readTemplateElements(template);
            for (String wood : WOOD_TYPES) {
                String texture = "minecraft:entity/signs/hanging/" + wood;
                String modelName = wood + "_hanging_sign_attached";
                map.put("assets/minecraft/models/block/" + modelName + ".json", GSON.toJson((JsonElement)SignModels.makeModelWithParticle("sign", texture, Model.getParticleTexture(wood), elements)).getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

