/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.util;

import betterblockentities.util.ModelTransform;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1792;
import net.minecraft.class_2350;
import net.minecraft.class_2508;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_8168;
import net.minecraft.class_8172;
import net.minecraft.class_8526;
import org.jetbrains.annotations.Nullable;

public class BlockRenderHelper {
    public static void emitQuads(List<class_10889> parts, QuadEmitter emitter, Predicate<@Nullable class_2350> cullTest) {
        int partCount = parts.size();
        for (int i = 0; i < partCount; ++i) {
            parts.get(i).emitQuads(emitter, cullTest);
        }
    }

    public static void emitDecoratedPotQuads(class_1087 model, class_2680 state, QuadEmitter emitter, class_8172 blockEntity, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        class_8526 sherds = blockEntity.method_51511();
        class_1058[] sideSprites = new class_1058[]{sherds.comp_1487().map(BlockRenderHelper::getSherdSprite).orElse(null), sherds.comp_1489().map(BlockRenderHelper::getSherdSprite).orElse(null), sherds.comp_1490().map(BlockRenderHelper::getSherdSprite).orElse(null), sherds.comp_1488().map(BlockRenderHelper::getSherdSprite).orElse(null)};
        QuadTransform[] sideTransforms = new QuadTransform[4];
        for (int i = 0; i < 4; ++i) {
            class_1058 s = sideSprites[i];
            sideTransforms[i] = s != null ? ModelTransform.swapSpriteCached(s) : null;
        }
        int facingIndex = BlockRenderHelper.horizontalIndex((class_2350)state.method_11654((class_2769)class_8168.field_42755));
        for (class_10889 part : model.method_68512(random)) {
            boolean skipTransform = part.method_68509(null).size() > 10;
            TriState ao = part.comp_3751() ? TriState.DEFAULT : TriState.FALSE;
            for (int i = 0; i <= 6; ++i) {
                class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
                if (cullTest.test(cullFace)) continue;
                for (class_777 quad : part.method_68509(cullFace)) {
                    emitter.cullFace(cullFace);
                    emitter.fromBakedQuad(quad);
                    emitter.ambientOcclusion(ao);
                    emitter.shadeMode(ShadeMode.VANILLA);
                    if (skipTransform) {
                        emitter.emit();
                        continue;
                    }
                    int dirIndex = BlockRenderHelper.horizontalIndex(quad.comp_3723());
                    if (dirIndex == -1) {
                        emitter.emit();
                        continue;
                    }
                    int delta = (dirIndex - facingIndex + 4) % 4;
                    QuadTransform transform = sideTransforms[delta];
                    if (transform != null) {
                        emitter.pushTransform(transform);
                        emitter.emit();
                        emitter.popTransform();
                        continue;
                    }
                    emitter.emit();
                }
            }
        }
    }

    private static class_1058 getSherdSprite(class_1792 item) {
        if (item == null) {
            return null;
        }
        String itemName = item.toString();
        String pattern = BlockRenderHelper.parseSherdName(itemName);
        class_2960 spriteId = class_2960.method_60656((String)("entity/decorated_pot/" + pattern + "_pottery_pattern"));
        return ModelTransform.getSprite(spriteId);
    }

    private static String parseSherdName(String id) {
        String path;
        int colonIndex = id.indexOf(58);
        String string = path = colonIndex >= 0 ? id.substring(colonIndex + 1) : id;
        if (path.endsWith("_pottery_sherd")) {
            return path.substring(0, path.length() - "_pottery_sherd".length());
        }
        return path;
    }

    private static int horizontalIndex(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> 0;
            case class_2350.field_11034 -> 1;
            case class_2350.field_11035 -> 2;
            case class_2350.field_11039 -> 3;
            default -> -1;
        };
    }

    public static float computeSignRotation(class_2680 state) {
        if (state.method_28498((class_2769)class_2508.field_11559)) {
            int rot = (Integer)state.method_11654((class_2769)class_2508.field_11559);
            return (float)rot * 22.5f;
        }
        return 0.0f;
    }
}

