package betterblockentities.gui;

/* minecraft */
import net.minecraft.block.entity.*;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

/*
    TODO: clean this shit up lol
*/

public class ConfigScreen extends class_4667 {
    private final ConfigHolder originalConfig;

    private class_7172<Boolean> masterToggle;
    private class_7172<Boolean>
            chestOpt,
            signOpt,
            shulkerOpt,
            bedOpt,
            bellOpt,
            potOpt,
            chestAnimOpt,
            signTextOpt,
            shulkerAnimOpt,
            bellAnimOpt,
            potAnimOpt;
    private class_7172<Integer>
            updateType,
            smoothness;
    private class_7172<Integer> signDistance;

    public ConfigScreen(class_437 parent) {
        super(parent, class_310.method_1551().field_1690, class_2561.method_43471("Better Block Entities"));
        this.originalConfig = ConfigManager.CONFIG.copy();
    }

    @Override
    protected void method_60325() {
        if (this.field_51824 == null) return;

        masterToggle = masterToggle();
        chestOpt = optimizeChests();
        signOpt = optimizeSigns();
        shulkerOpt = optimizeShulkers();
        bedOpt = optimizeBeds();
        bellOpt = optimizeBells();
        potOpt = optimizeDecoratedPots();
        updateType = updateType();
        smoothness = extraRenderPasses();
        signDistance = signTextRenderDistance();

        chestAnimOpt = chestsAnimations();
        signTextOpt = renderSignText();
        shulkerAnimOpt = shulkerAnimations();
        bellAnimOpt = bellAnimations();
        potAnimOpt = potAnimations();

        this.field_51824.method_20406(masterToggle);
        this.field_51824.method_20408(
                chestOpt, chestAnimOpt,
                signOpt, signTextOpt,
                shulkerOpt, shulkerAnimOpt,
                bellOpt, bellAnimOpt,
                potOpt, potAnimOpt,
                bedOpt
        );
        this.field_51824.method_20406(updateType);
        this.field_51824.method_20406(smoothness);
        this.field_51824.method_20406(signDistance);
        updateDependentOptions(masterToggle.method_41753());
    }

    private class_7172<Boolean> masterToggle() {
        return new class_7172<>(
                "Enable Optimizations",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns the entire optimization system on or off.")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.master_optimize,
                value -> {
                    ConfigManager.CONFIG.master_optimize = value;
                    updateDependentOptions(value);
                }
        );
    }

    private class_7172<Boolean> optimizeChests() {
        return new class_7172<>(
                "Optimize Chests",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns off all Chest optimizations, overrides the option: §l§nChest Animations§r")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.optimize_chests,
                v -> {
                    ConfigManager.CONFIG.optimize_chests = v;
                    setOptionActive(chestAnimOpt, v && masterToggle.method_41753());
                }
        );
    }

    private class_7172<Boolean> chestsAnimations() {
        return booleanOption(
                "Chest Animations",
                ConfigManager.CONFIG.chest_animations,
                v -> ConfigManager.CONFIG.chest_animations = v
        );
    }

    private class_7172<Boolean> optimizeSigns() {
        return new class_7172<>(
                "Optimize Signs",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns off all Sign optimizations, overrides the option: §l§nSign Text§r")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.optimize_signs,
                v -> {
                    ConfigManager.CONFIG.optimize_signs = v;
                    setOptionActive(signTextOpt, v && masterToggle.method_41753());
                }
        );
    }

    private class_7172<Boolean> renderSignText() {
        return booleanOption(
                "Sign Text",
                ConfigManager.CONFIG.render_sign_text,
                v -> ConfigManager.CONFIG.render_sign_text = v
        );
    }

    private class_7172<Boolean> optimizeShulkers() {
        return new class_7172<>(
                "Optimize Shulkers",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns off all ShulkerBox optimizations, overrides the option: §l§nShulker Animations§r")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.optimize_shulkers,
                v -> {
                    ConfigManager.CONFIG.optimize_shulkers = v;
                    setOptionActive(shulkerAnimOpt, v && masterToggle.method_41753());
                }
        );
    }

    private class_7172<Boolean> shulkerAnimations() {
        return booleanOption(
                "Shulker Animations",
                ConfigManager.CONFIG.shulker_animations,
                v -> ConfigManager.CONFIG.shulker_animations = v
        );
    }

    private class_7172<Boolean> optimizeBeds() {
        return new class_7172<>(
                "Optimize Beds",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns off all Bed optimizations")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.optimize_beds,
                v -> {
                    ConfigManager.CONFIG.optimize_beds = v;
                    setOptionActive(masterToggle, v && masterToggle.method_41753());
                }
        );
    }

    private class_7172<Boolean> optimizeBells() {
        return new class_7172<>(
                "Optimize Bells",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns off all Bell optimizations, overrides the option: §l§nBell Animations§r")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.optimize_bells,
                v -> {
                    ConfigManager.CONFIG.optimize_bells = v;
                    setOptionActive(bellAnimOpt, v && masterToggle.method_41753());
                }
        );
    }

    private class_7172<Boolean> bellAnimations() {
        return booleanOption(
                "Bell Animations",
                ConfigManager.CONFIG.bell_animations,
                v -> ConfigManager.CONFIG.bell_animations = v
        );
    }

    private class_7172<Boolean> optimizeDecoratedPots() {
        return new class_7172<>(
                "Optimize Decorated Pots",
                value -> class_7919.method_47407(class_2561.method_30163("§7Turns off all Decorated Pot optimizations, overrides the option: §l§nDecorated Pot Animations§r")),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                ConfigManager.CONFIG.optimize_decoratedpots,
                v -> {
                    ConfigManager.CONFIG.optimize_decoratedpots = v;
                    setOptionActive(potAnimOpt, v && masterToggle.method_41753());
                }
        );
    }

    private class_7172<Boolean> potAnimations() {
        return booleanOption(
                "Decorated Pot Animations",
                ConfigManager.CONFIG.pot_animations,
                v -> ConfigManager.CONFIG.pot_animations = v
        );
    }

    private class_7172<Integer> signTextRenderDistance() {
        return new class_7172<>(
                "Sign Text Render Distance",
                value -> class_7919.method_47407(class_2561.method_30163("§7The amount of blocks the sign text will stop rendering at")),
                (text, value) -> class_2561.method_30163(text.getString() + ": " + value),
                new class_7172.class_7174(0, 64),
                ConfigManager.CONFIG.sign_text_render_distance,
                v -> ConfigManager.CONFIG.sign_text_render_distance = v
        );
    }

    private class_7172<Integer> updateType() {
        return new class_7172<>(
                "Update Type",
                value -> class_7919.method_47407(class_2561.method_30163("§7Type of update scheduler being used. §l§nSmart§r §7updates only when the BE is not in line of sight or out of FOV. §l§nFast§r §7updates immediately")),
                (text, value) -> switch (value) {
                    case 0 -> class_2561.method_30163("Smart");
                    case 1 -> class_2561.method_30163("Fast");
                    default -> class_2561.method_30163("Fast");
                },
                new class_7172.class_7304(0, () -> 1, 1),
                ConfigManager.CONFIG.updateType,
                value -> ConfigManager.CONFIG.updateType = value
        );
    }

    private class_7172<Integer> extraRenderPasses() {
        return new class_7172<>(
                "Extra Render Passes",
                value -> class_7919.method_47407(class_2561.method_30163("§7The amount of extra render passes each optimized block entity should be rendered for after it stops animating, can help smooth out visual bugs")),
                (text, value) -> class_2561.method_30163(text.getString() + ": " + value),
                new class_7172.class_7174(0, 50),
                ConfigManager.CONFIG.smoothness_slider,
                v -> ConfigManager.CONFIG.smoothness_slider = v
        );
    }

    private class_7172<Boolean> booleanOption(String key, boolean initial, java.util.function.Consumer<Boolean> onChange) {
        return new class_7172<>(
                key,
                class_7172.method_42399(),
                (text, value) -> value ? class_2561.method_30163("§aON") : class_2561.method_30163("§cOFF"),
                class_7172.field_38278,
                initial,
                onChange
        );
    }

    private void updateDependentOptions(boolean enabled) {
        setOptionActive(chestOpt, enabled);
        setOptionActive(signOpt, enabled);
        setOptionActive(shulkerOpt, enabled);
        setOptionActive(bedOpt, enabled);
        setOptionActive(bellOpt, enabled);
        setOptionActive(potOpt, enabled);

        setOptionActive(chestAnimOpt, enabled && chestOpt.method_41753());
        setOptionActive(signTextOpt, enabled && signOpt.method_41753());
        setOptionActive(shulkerAnimOpt, enabled && shulkerOpt.method_41753());
        setOptionActive(bellAnimOpt, enabled && bellOpt.method_41753());
        setOptionActive(potAnimOpt, enabled && potOpt.method_41753());

        setOptionActive(smoothness, enabled);
        setOptionActive(updateType, enabled);
        setOptionActive(signDistance, enabled);
    }

    private void setOptionActive(class_7172<?> option, boolean active) {
        if (this.field_51824 == null) return;
        class_339 widget = this.field_51824.method_31046(option);
        if (widget != null) widget.field_22763 = active;
    }

    @Override
    public void method_25432() {
        if (!ConfigManager.CONFIG.equals(originalConfig)) {
            ConfigManager.save();
            ConfigManager.refreshSupportedTypes();
            class_310.method_1551().method_1521();
        }
    }
}
