package betterblockentities.mixin.minecraft;

/* local */
import betterblockentities.util.BlockEntityManager;

/* minecraft */
import net.minecraft.block.*;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4970.class)
public abstract class AbstractBlockMixin
{
    /* apparently we do not need this? getRenderType always return type MODEL anyway... */
    @Inject(method = "getRenderType", at = @At("HEAD"), cancellable = true)
    private void forceToMesh(class_2680 state, CallbackInfoReturnable<class_2464> cir) {
        if (BlockEntityManager.isSupportedBlock(state.method_26204()))
            cir.setReturnValue(class_2464.field_11458);
    }
}
