package betterblockentities.mixin.minecraft;

/* local */
import betterblockentities.resource.pack.ResourceBuilder;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
/* minecraft */
import net.minecraft.resource.*;

/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

/* java/misc */
import java.util.Map;

/*
    there is probably a better way to inject the pack profile
    but this works like I want it to... might cause issues later on
    with other mods that modify resource packs though (because of the
    ResourcePackPosition passed to the pack profile
    "
*/
@Mixin(class_3283.class)
public class ResourcePackManagerMixin
{
    @Inject(method = "providePackProfiles", at =
    @At(value = "INVOKE", target = "Lcom/google/common/collect/ImmutableMap;copyOf(Ljava/util/Map;)Lcom/google/common/collect/ImmutableMap;"),
            locals = LocalCapture.CAPTURE_FAILSOFT
    )
    private void injectGeneratedPackProfiles(CallbackInfoReturnable<Map<String, class_3288>> cir, Map<String, class_3288> map) {
        class_3288 generated = ResourceBuilder.buildPackProfile();

        /* remove the old profile if it exists */
        map.remove(generated.method_14463());

        if (generated != null && !map.containsKey(generated.method_14463())) {
            map.put(generated.method_14463(), generated);
        }
    }
}