package betterblockentities.mixin.minecraft.chest;

/* local */
import betterblockentities.gui.ConfigManager;
import betterblockentities.model.BBEChestBlockModel;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_826;
import net.minecraft.class_9944;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_826.class)
public abstract class ChestBlockEntityRendererMixin<T extends class_2586 & class_2618> {

    @Shadow @Mutable private class_9944 singleChest;
    @Shadow @Mutable private class_9944 doubleChestLeft;
    @Shadow @Mutable private class_9944 doubleChestRight;

    @Unique private class_9944 BBEsingleChest;
    @Unique private class_9944 BBEdoubleChestLeft;
    @Unique private class_9944 BBEdoubleChestRight;

    @Unique private class_9944 singleChestOrg;
    @Unique private class_9944 doubleChestLeftOrg;
    @Unique private class_9944 doubleChestRightOrg;

    // Initialize custom models
    @Inject(method = "<init>", at = @At("RETURN"))
    private void cacheAndInitModels(class_5614.class_5615 context, CallbackInfo ci) {
        this.singleChestOrg = new class_9944(context.method_32140(class_5602.field_27689));
        this.doubleChestLeftOrg = new class_9944(context.method_32140(class_5602.field_27551));
        this.doubleChestRightOrg = new class_9944(context.method_32140(class_5602.field_27552));

        this.BBEsingleChest = new BBEChestBlockModel(context.method_32140(class_5602.field_27689));
        this.BBEdoubleChestLeft = new BBEChestBlockModel(context.method_32140(class_5602.field_27551));
        this.BBEdoubleChestRight = new BBEChestBlockModel(context.method_32140(class_5602.field_27552));
    }

    // Swap models before rendering
    @Inject(method = "render(Lnet/minecraft/block/entity/BlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/util/math/Vec3d;)V", at = @At("HEAD"))
    private void render(T entity, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_243 cameraPos, CallbackInfo ci) {
        if (!ConfigManager.CONFIG.optimize_chests || !ConfigManager.CONFIG.master_optimize) {
            this.singleChest = singleChestOrg;
            this.doubleChestLeft = doubleChestLeftOrg;
            this.doubleChestRight = doubleChestRightOrg;
        } else {
            this.singleChest = BBEsingleChest;
            this.doubleChestLeft = BBEdoubleChestLeft;
            this.doubleChestRight = BBEdoubleChestRight;
        }
    }
}
