package betterblockentities.mixin.minecraft.sign;

/* local */
import betterblockentities.gui.ConfigManager;
import net.minecraft.class_10529;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_8242;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/*
    this whole mixin will probably get removed once we move to baking the sign text into meshes
    as this implementation is not as efficient
*/
@Mixin(class_10529.class)
public abstract class AbstractSignBlockEntityRendererMixin {
    @Shadow protected abstract void applyTransforms(class_4587 matrices, float blockRotationDegrees, class_2680 state);
    @Shadow protected abstract void renderText(class_2338 pos, class_8242 text, class_4587 matrices, class_4597 vertexConsumers, int light, int textLineHeight, int maxTextWidth, boolean front);

    /* to update just goto the AbstractSignBlockEntityRenderer class and IDEA -> View -> Show Bytecode */
    @Inject(method = "render(Lnet/minecraft/block/entity/SignBlockEntity;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/block/BlockState;Lnet/minecraft/block/AbstractSignBlock;Lnet/minecraft/block/WoodType;Lnet/minecraft/client/model/Model;)V", at = @At("HEAD"), cancellable = true)
    private void render(class_2625 blockEntity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_2680 state, class_2478 block, class_4719 woodType, class_3879 model, CallbackInfo ci) {
        if (!ConfigManager.CONFIG.optimize_signs || !ConfigManager.CONFIG.master_optimize) return;

        ci.cancel();

        class_8242 frontText = blockEntity.method_49853();
        class_8242 backText = blockEntity.method_49854();

        /* sanity check */
        if (frontText == null || backText == null) return;

        /* check if we have text */
        boolean hasTextFront = hasText(frontText.method_49877(false));
        boolean hasTextBack = hasText(backText.method_49877(false));

        /* if no text then don't render */
        if (!hasTextFront && !hasTextBack) return;

        matrices.method_22903();
        this.applyTransforms(matrices, -block.method_49814(state), state);

        if (hasTextFront) this.renderText(blockEntity.method_11016(), frontText, matrices, vertexConsumers, light, blockEntity.method_45469(), blockEntity.method_45470(), true);
        if (hasTextBack) this.renderText(blockEntity.method_11016(), backText, matrices, vertexConsumers, light, blockEntity.method_45469(), blockEntity.method_45470(), false);

        matrices.method_22909();
    }

    @Unique
    private boolean hasText(class_2561[] lines) {
        for (class_2561 line : lines) {
            if (line != null && !line.getString().isEmpty()) return true;
        }
        return false;
    }
}
