package betterblockentities.mixin.sodium;

/* local */
import betterblockentities.BetterBlockEntities;
import betterblockentities.ModelLoader;
import betterblockentities.gui.ConfigManager;
import betterblockentities.util.*;

/* sodium */
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.color.ColorProviderRegistry;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;

/* fabric */
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel;

/* minecraft */
import net.minecraft.block.*;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1092;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3709;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8168;
import net.minecraft.client.render.model.*;
/* mixin */
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/* java/misc */
import org.joml.Vector3f;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Pseudo
@Mixin(BlockRenderer.class)
public class BlockRendererMixin {
    @Shadow @Final private Vector3f posOffset;
    @Shadow @Nullable private ColorProvider<class_2680> colorProvider;
    @Shadow @Final private ColorProviderRegistry colorProviderRegistry;

    @Inject(method = "renderModel", at = @At("HEAD"), cancellable = true)
    private void renderModel(class_1087 model, class_2680 state, class_2338 pos, class_2338 origin, CallbackInfo ci) {
        try {
            /* should always be valid once this function executes, same goes for (model, state, pos, origin) */
            class_2248 block = state.method_26204();

            if (BlockEntityManager.isSupportedBlock(block) && !ConfigManager.CONFIG.master_optimize) {
                if (block instanceof class_3709) return;
                if (block instanceof class_2244) return;

                ci.cancel();
                return;
            }

            /* setup context */
            AbstractBlockRenderContextAccessor acc = setupContext(state, pos, origin);
            if (acc == null) return;
            final QuadEmitter emitter = acc.getEmitterInvoke();

            /* SIGNS */
            if (block instanceof class_2508 || block instanceof class_7713) {
                ci.cancel();

                if (!ConfigManager.CONFIG.optimize_signs) return;

                emitter.pushTransform(ModelTransform.rotateY(BlockRenderHelper.computeSignRotation(state)));
                ((FabricBlockStateModel) model).emitQuads(emitter, acc.getLevel(), pos, state, acc.getRandom(), acc::isFaceCulledInvoke);
                emitter.popTransform();
            }
            else if (block instanceof class_7715 || block instanceof class_2551) {
                if (!ConfigManager.CONFIG.optimize_signs)
                    ci.cancel();
            }

            /* SHULKERS, and CHESTS */
            else if (block instanceof class_2281 || block instanceof class_2336 || block instanceof class_2480) {
                boolean isShulker = block instanceof class_2480;

                if ((isShulker && !ConfigManager.CONFIG.optimize_shulkers) || (!isShulker && !ConfigManager.CONFIG.optimize_chests))
                    return;

                ci.cancel();

                List<class_10889> parts = model.method_68512(acc.getRandom());

                /* splice BlockModelParts from MultipartBlockStateModel */
                int quadThreshold = isShulker ? 10 : 6;
                Map<Boolean, List<class_10889>> partitioned = parts.stream()
                        .collect(Collectors.partitioningBy(p -> p.method_68509(null).size() > quadThreshold));

                List<class_10889> lidParts   = partitioned.get(true);
                List<class_10889> trunkParts = partitioned.get(false);

                List<class_10889> merged =  new ArrayList<>();

                BlockEntityExt ext = getBlockEntityInstance(pos);
                boolean shouldRender = shouldRender(ext);

                if (ConfigManager.CONFIG.updateType == 1)
                    merged.addAll(trunkParts);
                else {
                    if (shouldRender)
                        merged.addAll(trunkParts);
                }

                /* merge BlockModelParts after splicing */
                if (shouldRender) merged.addAll(lidParts);

                BlockRenderHelper.emitQuads(merged, emitter, acc::isFaceCulledInvoke);
            }

            /* BELLS */
            else if (block instanceof class_3709) {
                if (!ConfigManager.CONFIG.optimize_bells) return;
                ci.cancel();

                class_5819 rand = acc.getRandom();
                List<class_10889> bell_part = model.method_68512(rand);
                List<class_10889> bell_body_part = new ArrayList<>();

                BlockEntityExt ext = getBlockEntityInstance(pos);
                boolean shouldRender = shouldRender(ext);

                if (shouldRender) {
                    try {
                        class_1092 manager = class_310.method_1551().method_1554();
                        class_1087 bell_body = manager.getModel(ModelLoader.BELL_BODY_KEY);
                        bell_body_part.addAll(bell_body.method_68512(rand));
                    }
                    catch (Exception e) {
                        BetterBlockEntities.getLogger().error("Error: Retrieving bell body BlockModelPart at {}", pos, e);
                    }
                }

                List<class_10889> merged = new ArrayList<>(bell_part);
                if (!bell_body_part.isEmpty())
                    merged.addAll(bell_body_part);
                BlockRenderHelper.emitQuads(merged, emitter, acc::isFaceCulledInvoke);
            }

            /* DECORATED POTS */
            else if (block instanceof class_8168) {
                if (!ConfigManager.CONFIG.optimize_decoratedpots) {
                    ci.cancel();
                    return;
                }

                BlockEntityExt ext = getBlockEntityInstance(pos);
                boolean shouldRender = shouldRender(ext);

                if (!shouldRender) ci.cancel();
            }
            restoreContext();
        }
        catch (Exception e) {
            BetterBlockEntities.getLogger().error("Error: General fault in BlockRenderer at {}", pos, e);
        }
    }

    @Unique
    private boolean shouldRender(BlockEntityExt ext) {
        return ext == null || !ext.getRemoveChunkVariant();
    }

    /* safely retrieve block entity and an instance to our accessor  */
    @Unique
    private BlockEntityExt getBlockEntityInstance(class_2338 pos) {
        try {
            class_638 world = class_310.method_1551().field_1687;
            class_2586 blockEntity = world.method_8321(pos);
            return (blockEntity instanceof BlockEntityExt bex) ? bex : null;
        } catch (Exception e) {
            BetterBlockEntities.getLogger().error("Error: Getting Block Entity and accessor at {}", pos, e);
            return null;
        }
    }

    @Unique
    AbstractBlockRenderContextAccessor setupContext(class_2680 state, class_2338 pos, class_2338 origin) {
        try {
            AbstractBlockRenderContextAccessor acc = (AbstractBlockRenderContextAccessor)(Object)this;
            acc.setState(state);
            acc.setPos(pos);
            acc.prepareAoInfoInvoke(true);

            this.posOffset.set(origin.method_10263(), origin.method_10264(), origin.method_10260());
            if (state.method_49228()) {
                class_243 offset = state.method_26226(pos);
                this.posOffset.add((float) offset.field_1352, (float) offset.field_1351, (float) offset.field_1350);
            }

            this.colorProvider = this.colorProviderRegistry.getColorProvider(state.method_26204());
            acc.prepareCullingInvoke(true);
            acc.setDefaultRenderType(class_4696.method_23679(state));
            acc.setAllowDowngrade(true);
            acc.getRandom().method_43052(state.method_26190(pos));
            return acc;
        } catch (Exception e) {
            BetterBlockEntities.getLogger().error("Error: Setting up BlockRenderer context failed! at {}", pos, e);
            return null;
        }
    }

    @Unique
    void restoreContext() {
        AbstractBlockRenderContextAccessor acc = (AbstractBlockRenderContextAccessor)(Object)this;
        acc.setDefaultRenderType(null);
    }
}