package betterblockentities.mixin.sodium;

/* local */
import betterblockentities.util.BlockEntityManager;

/* sodium */
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;

/* minecraft */
import net.minecraft.block.entity.*;
import net.minecraft.class_2586;
import net.minecraft.class_3191;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_746;
import net.minecraft.class_824;
import net.minecraft.client.render.*;
/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/* java/misc */
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.SortedSet;

@Pseudo
@Mixin(SodiumWorldRenderer.class)
public abstract class SodiumWorldRendererMixin {
    @Inject(method = "renderBlockEntity", at = @At("HEAD"), cancellable = true)
    private static void renderBlockEntity(class_4587 matrices, class_4599 bufferBuilders, Long2ObjectMap<SortedSet<class_3191>> blockBreakingProgressions, float tickDelta, class_4597.class_4598 immediate, double x, double y, double z, class_824 dispatcher, class_2586 entity, class_746 player, LocalBooleanRef isGlowing, CallbackInfo ci) {
        if (!BlockEntityManager.shouldRender(entity))
            ci.cancel();
    }
}