package betterblockentities.resource.pack;

/* gson */
import betterblockentities.resource.model.ModelGenerator;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.resource.*;

/* java/misc */
import java.util.*;

public class ResourceBuilder
{
    /* generate the "in memory" resource pack to later be passed to our pack profile */
    public static byte[] buildZip() {
        PackMetadataBuilder meta = new PackMetadataBuilder();
        ModelGenerator models = new ModelGenerator();
        ResourcePackAssembler assembler = new ResourcePackAssembler();

        Map<String, byte[]> entries = new HashMap<>();
        entries.putAll(meta.createMetadataAndIcon());
        entries.putAll(models.generateAllModels());

        return assembler.assemble(entries);
    }

    /* builds the resource pack and its profile, should be called once on mod initialization */
    public static class_3288 buildPackProfile() {
        byte[] packData = buildZip();
        class_3262 pack = new Pack("betterblockentities-generated", packData);

        class_3288.class_7680 factory = new class_3288.class_7680() {
            @Override
            public class_3262 method_52424(class_9224 info) {
                return pack;
            }

            @Override
            public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
                return pack;
            }
        };

        class_9225 pos = new class_9225(true, class_3288.class_3289.field_14280, true);
        return class_3288.method_45275(pack.method_56926(), factory, class_3264.field_14188, pos);
    }
}
