package betterblockentities.util;

/* local */
import betterblockentities.BetterBlockEntities;
import betterblockentities.chunk.ChunkUpdateDispatcher;
import betterblockentities.gui.ConfigManager;

/* minecraft */
import net.minecraft.block.*;
import net.minecraft.block.entity.*;
import net.minecraft.class_1297;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2336;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_2625;
import net.minecraft.class_2627;
import net.minecraft.class_310;
import net.minecraft.class_3709;
import net.minecraft.class_3721;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7717;
import net.minecraft.class_8168;
import net.minecraft.class_8172;
/* java/misc */
import java.util.Collections;
import java.util.Set;

/*
    TODO: instead of sending chunk updates for each iteration,
          capture block pos of all blocks that needs a update
          and just send all the updates after collection.
 */

public class BlockEntityManager {
    public static Set<Class<? extends class_2586>> SUPPORTED_TYPES = Collections.emptySet();
    public static final Set<Class<? extends class_2248>> SUPPORTED_BLOCKS = Set.of(
            class_2281.class, class_2336.class, class_2480.class,
            class_3709.class, class_8168.class, class_2244.class,
            class_2508.class, class_7713.class,
            class_2551.class, class_7715.class
    );

    public static boolean chestAnims, shulkerAnims, bellAnims, potAnims, signText, masterOptimize;
    public static int smoothness;

    public static boolean isSupportedBlock(class_2248 block) {
        return block != null && SUPPORTED_BLOCKS.contains(block.getClass());
    }

    public static boolean isSupportedEntity(class_2586 blockEntity) {
        return blockEntity != null && SUPPORTED_TYPES.contains(blockEntity.getClass());
    }

    public static boolean isSignEntity(class_2586 blockEntity) {
        return blockEntity != null &&
                class_2625.class == blockEntity.getClass() ||
                class_7717.class == blockEntity.getClass();
    }

    private static boolean isAnimating(class_2586 blockEntity) {
        if (chestAnims && blockEntity instanceof class_2618 lid)
            return lid.method_11274(0.5f) > 0f;
        if (shulkerAnims && blockEntity instanceof class_2627 shulker)
            return shulker.method_11312(0.5f) > 0f;
        if (bellAnims && blockEntity instanceof class_3721 bell)
            return bell.field_17096;
        if (potAnims && blockEntity instanceof class_8172 pot && pot.field_46662 != null) {
            long now = blockEntity.method_10997().method_8510();
            return now - pot.field_46661 < pot.field_46662.field_46666;
        }
        if (signText && blockEntity instanceof class_2625) {
            //int chunkRenderDistance = MinecraftClient.getInstance().options.getViewDistance().getValue();

            /* distance in blocks not chunks */
            double maxSignTextDistance = ConfigManager.CONFIG.sign_text_render_distance;

            class_1297 entity = class_310.method_1551().method_1560();
            boolean shouldRenderText = entity.method_5707(class_243.method_24953(blockEntity.method_11016())) < maxSignTextDistance * maxSignTextDistance;
            if (shouldRenderText)
                return true;
        }
        return false;
    }

    public static boolean shouldRender(class_2586 blockEntity) {
        if (!masterOptimize) return true;

        /* are we a supported BE and are the config options enabled */
        if (!isSupportedEntity(blockEntity)) return true;

        /* did we just receive a block event, if not don't render with BER */
        BlockEntityExt inst = (BlockEntityExt) blockEntity;
        if (!inst.getJustReceivedUpdate() && !isSignEntity(blockEntity)) {
            return false;
        }

        /* animation logic (static and animating) */
        return isAnimating(blockEntity) ? handleAnimating(blockEntity, inst) : handleStatic(blockEntity, inst);
    }

    private static boolean handleAnimating(class_2586 blockEntity, BlockEntityExt inst) {
        var pos = blockEntity.method_11016().method_10063();

        /* ignore signs as we render the text with its BER  */
        if (!(blockEntity instanceof class_2625)) {
            /* add to anim map if an entry doesn't exist */
            if (BlockEntityTracker.animMap.add(pos)) {
                inst.setRemoveChunkVariant(true);
                ChunkUpdateDispatcher.queueRebuildAtBlockPos(blockEntity.method_10997(), pos);
            }
        }
        return true;
    }

    private static boolean handleStatic(class_2586 blockEntity, BlockEntityExt inst) {
        var pos = blockEntity.method_11016().method_10063();

        if (ConfigManager.CONFIG.updateType == 0)
        {
            if (!BlockEntityTracker.animMap.contains(pos))
                return false;

            /* captured frustum */
            var frustum = BetterBlockEntities.curFrustum;

            /* check sanity (visible or not) */
            if (BlockVisibilityChecker.isBlockInFOVAndVisible(frustum, blockEntity))
                return true;
            else {
                if (BlockEntityTracker.animMap.remove(pos)) {
                    inst.setRemoveChunkVariant(false);
                    ChunkUpdateDispatcher.queueRebuildAtBlockPos(blockEntity.method_10997(), pos);
                }
                Integer passes = BlockEntityTracker.extraRenderPasses.compute(pos, (p, v) -> {
                    if (v == null) return null;
                    if (v > 1) return v - 1;
                    inst.setJustReceivedUpdate(false);
                    return null;
                });
                return passes != null;
            }
        }
        else {
            if (BlockEntityTracker.animMap.remove(pos)) {
                inst.setRemoveChunkVariant(false);
                ChunkUpdateDispatcher.queueRebuildAtBlockPos(blockEntity.method_10997(), pos);
                BlockEntityTracker.extraRenderPasses.put(pos, smoothness);
            }

            Integer passes = BlockEntityTracker.extraRenderPasses.compute(pos, (p, v) -> {
                if (v == null) return null;
                if (v > 1) return v - 1;
                inst.setJustReceivedUpdate(false);
                return null;
            });
            return passes != null;
        }
    }
}
