package betterblockentities.util;


/* java/misc */
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4604;

public class BlockVisibilityChecker {
    /* checks if passed blockEntity is in the view frustum and LOS in not blocked */
    public static boolean isBlockInFOVAndVisible(class_4604 frustum, class_2586 blockEntity) {
        class_1297 player = class_310.method_1551().method_1560();
        class_2338 blockPos = blockEntity.method_11016();
        class_243 eyePos = player.method_5836(1.0f);

        /* center of the block */
        class_243 center = new class_243(
                blockPos.method_10263() + 0.5,
                blockPos.method_10264() + 0.5,
                blockPos.method_10260() + 0.5
        );

        /* max distance check */
        double maxDistance = 20.0;
        if (eyePos.method_1025(center) > maxDistance * maxDistance) return false;

        /* check if block is inside view frustum */
        if (!isBlockInViewFrustum(frustum, blockEntity)) return false;

        /* LOS check to multiple points on the block */
        for (class_243 offset : BLOCK_SAMPLE_OFFSETS) {
            class_243 target = new class_243(
                    blockPos.method_10263() + offset.field_1352,
                    blockPos.method_10264() + offset.field_1351,
                    blockPos.method_10260() + offset.field_1350
            );

            class_239 hit = player.method_37908().method_17742(new class_3959(
                    eyePos,
                    target,
                    class_3959.class_3960.field_23142,
                    class_3959.class_242.field_1348,
                    player
            ));

            /* did we hit? return early */
            if (hit.method_17783() == class_239.class_240.field_1332 && ((class_3965) hit).method_17777().equals(blockPos)) {
                return true;
            }
        }
        return false; //all sample points blocked
    }

    /* setup bounding box */
    private static class_238 setupBox(class_2586 entity, class_2338 pos) {
        if (entity instanceof class_2573)
            return new class_238(pos).method_1009(0, 1, 0);
        return new class_238(pos);
    }

    /* preform frustum visibility check */
    private static boolean isBlockInViewFrustum(class_4604 frustum, class_2586 blockEntity) {
        return frustum != null && frustum.method_23093(setupBox(blockEntity, blockEntity.method_11016()));
    }

    /* generate sample points to raycast to */
    private static class_243[] generateFaceGrid(int resolution) {
        List<class_243> list = new ArrayList<>();
        double step = 1.0 / (resolution - 1);

        for (int y = 0; y < resolution; y++) {
            for (int x = 0; x < resolution; x++) {
                double u = x * step; // horizontal
                double v = y * step; // vertical

                list.add(new class_243(0.0, v, u));
                list.add(new class_243(1.0, v, u));
                list.add(new class_243(u, v, 0.0));
                list.add(new class_243(u, v, 1.0));
                list.add(new class_243(u, 0.0, v));
                list.add(new class_243(u, 1.0, v));
            }
        }
        return list.toArray(new class_243[0]);
    }

    /* sample points */
    private static final class_243[] BLOCK_SAMPLE_OFFSETS = generateFaceGrid(5);
}
