/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.setup;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.TFCCreativeTabs;
import net.dries007.tfc.common.recipes.DelegateRecipe;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.labellum.mc.waterflasks.item.FlaskItem;
import org.labellum.mc.waterflasks.setup.AddItemChanceModifier;
import org.labellum.mc.waterflasks.setup.HealFlaskRecipe;

public class Registration {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waterflasks");
    private static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"waterflasks");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"waterflasks");
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"waterflasks");
    public static final TagKey<Item> FLASKS = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)new ResourceLocation("waterflasks", "flasks"));
    public static final RegistryObject<Codec<AddItemChanceModifier>> ADD_ITEM = Registration.glmSerializer("add_item", () -> AddItemChanceModifier.CODEC);
    public static final RegistryObject<Item> LEATHER_SIDE = Registration.register("leather_side");
    public static final RegistryObject<Item> BLADDER = Registration.register("bladder");
    public static final RegistryObject<Item> BROKEN_LEATHER_FLASK = Registration.register("broken_leather_flask");
    public static final RegistryObject<Item> LEATHER_FLASK = Registration.register("leather_flask", () -> new FlaskItem(Registration.leatherProperties(), () -> 500, 100, (Supplier<? extends Item>)BROKEN_LEATHER_FLASK));
    public static final RegistryObject<Item> UNFINISHED_FLASK = Registration.register("unfinished_iron_flask");
    public static final RegistryObject<Item> BROKEN_IRON_FLASK = Registration.register("broken_iron_flask");
    public static final RegistryObject<Item> IRON_FLASK = Registration.register("iron_flask", () -> new FlaskItem(Registration.ironProperties(), () -> 2000, 100, (Supplier<? extends Item>)BROKEN_IRON_FLASK));
    public static final RegistryObject<Item> UNFINISHED_RED_STEEL_FLASK = Registration.register("unfinished_red_steel_flask", () -> new Item(new Item.Properties().m_41497_(Rarity.EPIC)));
    public static final RegistryObject<Item> RED_STEEL_FLASK = Registration.register("red_steel_flask", () -> new FlaskItem(Registration.redSteelProperties(), () -> 2000, 100, (Supplier<? extends Item>)UNFINISHED_RED_STEEL_FLASK));
    public static final TFCCreativeTabs.CreativeTabHolder FLASKTAB = Registration.register("flasks", () -> new ItemStack((ItemLike)LEATHER_FLASK.get()), Registration::fillTab);
    public static final RegistryObject<SoundEvent> FLASK_BREAK = SOUNDS.register("item.flaskbreak", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("waterflasks", "item.flaskbreak")));
    public static final RegistryObject<RecipeSerializer<?>> HEAL_FLASK_SERIALIZER = Registration.registerSerializer("heal_flask", () -> DelegateRecipe.Serializer.shaped(HealFlaskRecipe::new));

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        SOUNDS.register(bus);
        MODIFIER_SERIALIZERS.register(bus);
        RECIPE_SERIALIZERS.register(bus);
    }

    private static void fillTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        Registration.accept(out, LEATHER_SIDE);
        Registration.accept(out, BLADDER);
        Registration.accept(out, BROKEN_LEATHER_FLASK);
        Registration.accept(out, LEATHER_FLASK);
        Registration.accept(out, UNFINISHED_FLASK);
        Registration.accept(out, BROKEN_IRON_FLASK);
        Registration.accept(out, IRON_FLASK);
        Registration.accept(out, UNFINISHED_RED_STEEL_FLASK);
        Registration.accept(out, RED_STEEL_FLASK);
    }

    private static Item.Properties leatherProperties() {
        return new Item.Properties().m_41503_(100);
    }

    private static Item.Properties ironProperties() {
        return new Item.Properties().m_41503_(400);
    }

    private static Item.Properties redSteelProperties() {
        return new Item.Properties().m_41503_(-1).m_41497_(Rarity.EPIC);
    }

    private static RegistryObject<Item> register(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> supplier) {
        return ITEMS.register(name, supplier);
    }

    private static TFCCreativeTabs.CreativeTabHolder register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        RegistryObject reg = TFCCreativeTabs.CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)"item.waterflasks.leather_flask")).m_257501_(displayItems).m_257652_());
        return new TFCCreativeTabs.CreativeTabHolder(reg, displayItems);
    }

    private static <T extends IGlobalLootModifier> RegistryObject<Codec<T>> glmSerializer(String id, Supplier<Codec<T>> modifier) {
        return MODIFIER_SERIALIZERS.register(id, modifier);
    }

    private static <S extends RecipeSerializer<?>> RegistryObject<S> registerSerializer(String name, Supplier<S> factory) {
        return RECIPE_SERIALIZERS.register(name, factory);
    }

    private static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == Items.f_41852_) {
            TerraFirmaCraft.LOGGER.error("BlockItem with no Item added to creative tab: " + String.valueOf(reg));
            SelfTests.reportExternalError();
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }
}

