/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.one_up_totems.impl.common.network;

import forge.com.cursee.one_up_totems.OneUpTotemsClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeModNetwork {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("one_up_totems", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(ForgeLifeCountS2CPacket.class, ForgeModNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(ForgeLifeCountS2CPacket::new).encoder(ForgeLifeCountS2CPacket::toBytes).consumerMainThread(ForgeLifeCountS2CPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(ServerPlayer serverPlayer, MSG message) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
    }

    static {
        packetId = 0;
    }

    public static class ForgeLifeCountS2CPacket {
        private final int lives;

        public ForgeLifeCountS2CPacket(FriendlyByteBuf friendlyByteBuf) {
            this.lives = friendlyByteBuf.m_130242_();
        }

        public void toBytes(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130130_(this.lives);
        }

        public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                int lives = this.lives;
                OneUpTotemsClient.LIVES_DISPLAY_INT.set(lives);
                context.setPacketHandled(true);
            });
            return true;
        }
    }
}

