/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.one_up_totems.impl.common.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private boolean cached = false;
    private T cachedValue;

    protected CachedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (!this.isCached()) {
            this.cachedValue = this.delegate.get();
            this.cached = true;
        }
        return this.cachedValue;
    }

    public void invalidate() {
        this.cached = false;
        this.cachedValue = null;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void ifCached(Consumer<T> consumer) {
        if (this.isCached()) {
            consumer.accept(this.get());
        }
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.cachedValue != null) {
            consumer.accept(this.get());
        }
    }

    public void apply(Consumer<T> consumer) {
        consumer.accept(this.get());
    }

    public <X> CachedSupplier<X> cast() {
        return this;
    }

    public static <T> CachedSupplier<T> singleton(T singleton) {
        return CachedSupplier.cache(() -> singleton);
    }

    public static <T> CachedSupplier<T> cache(Supplier<T> delegate) {
        return new CachedSupplier<T>(delegate);
    }

    public static <T> CachedSupplier<T> of(ResourceKey<T> key) {
        return CachedSupplier.cache(() -> {
            Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(key.m_211136_());
            if (registry == null) {
                System.out.println("[OneUpTotems] Registry " + String.valueOf(key.m_211136_()) + " could not be found!");
                throw new IllegalStateException("Registry with name " + String.valueOf(key.m_211136_()) + " was not found!");
            }
            return registry.m_123013_(key);
        });
    }

    public static <T> CachedSupplier<T> of(Registry<T> registry, String namespace, String path) {
        return CachedSupplier.of(registry, new ResourceLocation(namespace, path));
    }

    public static <T> CachedSupplier<T> of(Registry<T> registry, ResourceLocation id) {
        return CachedSupplier.cache(() -> registry.m_7745_(id));
    }
}

