/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.better_falling.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mcreator.better_falling.BetterFallingModPlayerAnimationAPI;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerAnimationRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    private String master = null;

    public PlayerAnimationRendererMixin(EntityRendererProvider.Context context, boolean slim) {
        super(null, null, 0.5f);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/player/PlayerRenderer;setupRotations(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;FF)V"}, at={@At(value="RETURN")})
    private void setupRotations(PlayerRenderState renderState, PoseStack poseStack, float bodyRot, float scale_, CallbackInfo ci) {
        Vec3 rotation;
        Vec3 position;
        Player player = (Player)renderState.getRenderData(BetterFallingModPlayerAnimationAPI.ClientAttachments.PLAYER);
        if (player == null) {
            return;
        }
        if (this.master == null) {
            if (!BetterFallingModPlayerAnimationAPI.animations.isEmpty()) {
                this.master = "better_falling";
            } else {
                return;
            }
        }
        if (!this.master.equals("better_falling")) {
            return;
        }
        BetterFallingModPlayerAnimationAPI.PlayerAnimation animation = BetterFallingModPlayerAnimationAPI.active_animations.get(player);
        if (animation == null) {
            return;
        }
        BetterFallingModPlayerAnimationAPI.PlayerBone bone = animation.bones.get("body");
        if (bone == null) {
            return;
        }
        float animationProgress = player.getPersistentData().getFloatOr("PlayerAnimationProgress", 0.0f);
        Vec3 scale = BetterFallingModPlayerAnimationAPI.PlayerBone.interpolate(bone.scales, animationProgress);
        if (scale != null) {
            poseStack.scale((float)scale.x, (float)scale.y, (float)scale.z);
        }
        if ((position = BetterFallingModPlayerAnimationAPI.PlayerBone.interpolate(bone.positions, animationProgress)) != null) {
            poseStack.translate((float)(-position.x) * 0.0625f, (float)(position.y * 0.0625), (float)position.z * 0.0625f);
        }
        if ((rotation = BetterFallingModPlayerAnimationAPI.PlayerBone.interpolate(bone.rotations, animationProgress)) != null) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation.z));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(-rotation.y)));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(-rotation.x)));
        }
    }
}

