/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.better_falling.network;

import net.mcreator.better_falling.BetterFallingMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record PlayPlayerAnimationMessage(int player, String animation, boolean override, boolean firstPerson) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayPlayerAnimationMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"better_falling", (String)"play_player_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayPlayerAnimationMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.player);
        buffer.writeUtf(message.animation);
        buffer.writeBoolean(message.override);
        buffer.writeBoolean(message.firstPerson);
    }, buffer -> new PlayPlayerAnimationMessage(buffer.readInt(), buffer.readUtf(), buffer.readBoolean(), buffer.readBoolean()));

    public CustomPacketPayload.Type<PlayPlayerAnimationMessage> type() {
        return TYPE;
    }

    public static void handleData(PlayPlayerAnimationMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                Player player = (Player)context.player().level().getEntity(message.player);
                if (player == null) {
                    return;
                }
                CompoundTag data = player.getPersistentData();
                if (message.animation.isEmpty()) {
                    data.putBoolean("ResetPlayerAnimation", true);
                    data.putBoolean("FirstPersonAnimation", false);
                    data.remove("PlayerCurrentAnimation");
                    data.remove("PlayerAnimationProgress");
                } else {
                    data.putString("PlayerCurrentAnimation", message.animation);
                    data.putBoolean("OverrideCurrentAnimation", message.override);
                    data.putBoolean("FirstPersonAnimation", message.firstPerson);
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BetterFallingMod.addNetworkMessage(TYPE, STREAM_CODEC, PlayPlayerAnimationMessage::handleData);
    }
}

