/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.config;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibConfigMerger {
    private final JavaPlugin plugin;

    public MrLibConfigMerger(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void mergeConfigs(File localFile, File remoteFile, String configName) {
        try {
            if (!localFile.exists()) {
                Files.copy(remoteFile.toPath(), localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Created " + configName + " from remote");
                return;
            }
            File backupFolder = new File(this.plugin.getDataFolder(), "backupFiles");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            File backupFile = new File(backupFolder, configName + ".pre-merge-backup." + timestamp);
            Files.copy(localFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            MrLibConsoleSayer.MrSay_Info("[" + this.plugin.getName() + "] Backed up " + configName + " to backupFiles/" + backupFile.getName());
            YamlConfiguration localConfig = YamlConfiguration.loadConfiguration((File)localFile);
            YamlConfiguration remoteConfig = YamlConfiguration.loadConfiguration((File)remoteFile);
            YamlConfiguration mergedConfig = new YamlConfiguration();
            HashSet<String> allPaths = new HashSet<String>();
            allPaths.addAll(this.getAllPaths(localConfig));
            allPaths.addAll(this.getAllPaths(remoteConfig));
            for (String path : allPaths) {
                if (localConfig.contains(path) && !localConfig.isConfigurationSection(path)) {
                    mergedConfig.set(path, localConfig.get(path));
                    continue;
                }
                if (!remoteConfig.contains(path) || remoteConfig.isConfigurationSection(path)) continue;
                mergedConfig.set(path, remoteConfig.get(path));
            }
            String versionKey = configName.replace(".yml", "") + "-version";
            if (remoteConfig.contains(versionKey)) {
                mergedConfig.set(versionKey, remoteConfig.get(versionKey));
            }
            mergedConfig.save(localFile);
            MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Merged " + configName + " - preserved user data, added new structure");
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("[" + this.plugin.getName() + "] Failed to merge " + configName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void smartMerge(File localFile, File remoteFile, String configName) {
        try {
            if (!localFile.exists()) {
                Files.copy(remoteFile.toPath(), localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Created " + configName + " from remote");
                return;
            }
            File backupFolder = new File(this.plugin.getDataFolder(), "backupFiles");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            File backupFile = new File(backupFolder, configName + ".pre-merge-backup." + timestamp);
            Files.copy(localFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            YamlConfiguration localConfig = YamlConfiguration.loadConfiguration((File)localFile);
            YamlConfiguration remoteConfig = YamlConfiguration.loadConfiguration((File)remoteFile);
            YamlConfiguration mergedConfig = new YamlConfiguration();
            Set<String> preserveSections = this.getPreserveSections(configName);
            Set<String> updateSections = this.getUpdateSections(configName);
            for (String section : preserveSections) {
                if (!localConfig.contains(section)) continue;
                this.copySection(localConfig, mergedConfig, section);
            }
            for (String section : updateSections) {
                if (!remoteConfig.contains(section)) continue;
                if (localConfig.contains(section)) {
                    this.mergeSection(localConfig, remoteConfig, mergedConfig, section);
                    continue;
                }
                this.copySection(remoteConfig, mergedConfig, section);
            }
            for (String key : localConfig.getKeys(false)) {
                if (mergedConfig.contains(key)) continue;
                if (localConfig.isConfigurationSection(key)) {
                    this.copySection(localConfig, mergedConfig, key);
                    continue;
                }
                mergedConfig.set(key, localConfig.get(key));
            }
            String versionKey = configName.replace(".yml", "") + "-version";
            if (remoteConfig.contains(versionKey)) {
                mergedConfig.set(versionKey, remoteConfig.get(versionKey));
            }
            mergedConfig.save(localFile);
            MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Smart merged " + configName);
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("[" + this.plugin.getName() + "] Failed to smart merge " + configName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void mergeMessagesOnly(File localFile, File remoteFile, String configName) {
        try {
            if (!localFile.exists()) {
                Files.copy(remoteFile.toPath(), localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Created " + configName + " from remote");
                return;
            }
            File backupFolder = new File(this.plugin.getDataFolder(), "backupFiles");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            File backupFile = new File(backupFolder, configName + ".pre-merge-backup." + timestamp);
            Files.copy(localFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            YamlConfiguration localConfig = YamlConfiguration.loadConfiguration((File)localFile);
            YamlConfiguration remoteConfig = YamlConfiguration.loadConfiguration((File)remoteFile);
            YamlConfiguration mergedConfig = new YamlConfiguration();
            HashSet<String> allKeys = new HashSet<String>();
            allKeys.addAll(this.getAllPaths(localConfig));
            allKeys.addAll(this.getAllPaths(remoteConfig));
            for (String key : allKeys) {
                if (localConfig.contains(key)) {
                    mergedConfig.set(key, localConfig.get(key));
                    continue;
                }
                if (!remoteConfig.contains(key)) continue;
                mergedConfig.set(key, remoteConfig.get(key));
            }
            String versionKey = configName.replace(".yml", "") + "-version";
            if (remoteConfig.contains(versionKey)) {
                mergedConfig.set(versionKey, remoteConfig.get(versionKey));
            }
            mergedConfig.save(localFile);
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("[" + this.plugin.getName() + "] Failed to merge messages: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Set<String> getPreserveSections(String configName) {
        HashSet<String> sections = new HashSet<String>();
        if (this.plugin.getName().equals("MrSellChests") && configName.equals("config.yml")) {
            sections.add("SellChests");
            sections.add("MrSellChests.SellChests");
            sections.add("SettingsMenu");
            sections.add("MrSellChests.SettingsMenu");
        }
        if (this.plugin.getName().equals("MrUltimateShop") && configName.equals("config.yml")) {
            sections.add("ChestShops.Menu");
            sections.add("MrUltimateShop.ChestShops.Menu");
        }
        return sections;
    }

    private Set<String> getUpdateSections(String configName) {
        HashSet<String> sections = new HashSet<String>();
        if (this.plugin.getName().equals("MrSellChests") && configName.equals("config.yml")) {
            sections.add("MrSellChests.Database");
            sections.add("MrSellChests.Holograms");
            sections.add("MrSellChests.SellPrices");
            sections.add("MrSellChests.Economy");
            sections.add("MrSellChests.Sell-Message");
            sections.add("MrSellChests.OfflineSell");
        }
        if (this.plugin.getName().equals("MrUltimateFishing") && configName.equals("config.yml")) {
            sections.add("MrUltimateFishing.Database");
            sections.add("MrUltimateFishing.HologramProvider");
            sections.add("MrUltimateFishing.UpdateInterval");
            sections.add("MrUltimateFishing.Fishing");
            sections.add("MrUltimateFishing.Leveling");
            sections.add("MrUltimateFishing.Economy");
            sections.add("MrUltimateFishing.Player-Data");
            sections.add("MrUltimateFishing.Debug");
            sections.add("MrUltimateFishing.Fallback");
            sections.add("MrUltimateFishing.General");
            sections.add("MrUltimateFishing.Upgrades");
            sections.add("MrUltimateFishing.CustomDrops");
            sections.add("MrUltimateFishing.Totem");
            sections.add("MrUltimateFishing.CustomEnchants");
        }
        if (this.plugin.getName().equals("MrUltimateFishing") && configName.equals("messages.yml")) {
            sections.add("MrUltimateFishing.Items");
            sections.add("MrUltimateFishing.menu-keys");
        }
        return sections;
    }

    private void copySection(YamlConfiguration source, YamlConfiguration target, String path) {
        if (source.isConfigurationSection(path)) {
            ConfigurationSection section = source.getConfigurationSection(path);
            if (section != null) {
                for (String key : section.getKeys(true)) {
                    String fullPath = path + "." + key;
                    if (source.isConfigurationSection(fullPath)) continue;
                    target.set(fullPath, source.get(fullPath));
                }
            }
        } else {
            target.set(path, source.get(path));
        }
    }

    private void mergeSection(YamlConfiguration local, YamlConfiguration remote, YamlConfiguration merged, String path) {
        ConfigurationSection localSection = local.getConfigurationSection(path);
        ConfigurationSection remoteSection = remote.getConfigurationSection(path);
        if (localSection == null && remoteSection == null) {
            return;
        }
        HashSet allKeys = new HashSet();
        if (localSection != null) {
            allKeys.addAll(localSection.getKeys(true));
        }
        if (remoteSection != null) {
            allKeys.addAll(remoteSection.getKeys(true));
        }
        for (String key : allKeys) {
            String fullPath = path + "." + key;
            if (local.contains(fullPath) && !local.isConfigurationSection(fullPath)) {
                merged.set(fullPath, local.get(fullPath));
                continue;
            }
            if (!remote.contains(fullPath) || remote.isConfigurationSection(fullPath)) continue;
            merged.set(fullPath, remote.get(fullPath));
        }
    }

    private Set<String> getAllPaths(YamlConfiguration config) {
        HashSet<String> paths = new HashSet<String>();
        for (String key : config.getKeys(true)) {
            if (config.isConfigurationSection(key)) continue;
            paths.add(key);
        }
        return paths;
    }
}

