/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.gui;

import eu.mrneznamy.mrlibcore.gui.MrLibGUI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MrLibPagedGUI
extends MrLibGUI {
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private final List<Consumer<Player>> itemActions = new ArrayList<Consumer<Player>>();
    private int currentPage = 0;
    private final int itemsPerPage;
    private final int[] itemSlots;

    public MrLibPagedGUI(String title, int rows) {
        super(title, rows);
        this.itemsPerPage = (rows - 1) * 9;
        this.itemSlots = new int[this.itemsPerPage];
        for (int i = 0; i < this.itemsPerPage; ++i) {
            this.itemSlots[i] = i;
        }
        this.setupNavigation();
    }

    public MrLibPagedGUI addPageItem(ItemStack item, Consumer<Player> action) {
        this.items.add(item);
        this.itemActions.add(action);
        return this;
    }

    private void updatePage() {
        for (int slot : this.itemSlots) {
            this.setItem(slot, null);
        }
        int start = this.currentPage * this.itemsPerPage;
        int end = Math.min(start + this.itemsPerPage, this.items.size());
        for (int i = start; i < end; ++i) {
            int slot;
            slot = this.itemSlots[i - start];
            int index = i;
            this.setItem(slot, this.items.get(i), event -> {
                if (this.itemActions.get(index) != null) {
                    this.itemActions.get(index).accept((Player)event.getWhoClicked());
                }
            });
        }
        this.updateNavigationButtons();
    }

    private void setupNavigation() {
        int lastRow = this.getSize() - 9;
        ItemStack prevButton = this.createNavigationItem(Material.ARROW, "&cPrevious Page");
        this.setItem(lastRow + 3, prevButton, event -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updatePage();
            }
        });
        ItemStack nextButton = this.createNavigationItem(Material.ARROW, "&aNext Page");
        this.setItem(lastRow + 5, nextButton, event -> {
            if (this.hasNextPage()) {
                ++this.currentPage;
                this.updatePage();
            }
        });
        ItemStack closeButton = this.createNavigationItem(Material.BARRIER, "&cClose");
        this.setItem(lastRow + 4, closeButton, event -> event.getWhoClicked().closeInventory());
    }

    private void updateNavigationButtons() {
        int lastRow = this.getSize() - 9;
        Material prevMaterial = this.currentPage > 0 ? Material.ARROW : Material.GRAY_DYE;
        this.setItem(lastRow + 3, this.createNavigationItem(prevMaterial, "&cPrevious Page"));
        Material nextMaterial = this.hasNextPage() ? Material.ARROW : Material.GRAY_DYE;
        this.setItem(lastRow + 5, this.createNavigationItem(nextMaterial, "&aNext Page"));
        int totalPages = (int)Math.ceil((double)this.items.size() / (double)this.itemsPerPage);
        ItemStack pageInfo = this.createNavigationItem(Material.PAPER, "&ePage " + (this.currentPage + 1) + "/" + Math.max(1, totalPages));
        this.setItem(lastRow + 4, pageInfo);
    }

    private boolean hasNextPage() {
        return (this.currentPage + 1) * this.itemsPerPage < this.items.size();
    }

    private ItemStack createNavigationItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name.replace("&", "\u00a7"));
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public void open(Player player) {
        this.currentPage = 0;
        this.updatePage();
        super.open(player);
    }
}

