/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibEntityHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibNativeHologramProvider;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MrLibHologramManager {
    private static MrLibHologramManager instance;
    private final Map<String, MrLibHologramProvider> providers = new HashMap<String, MrLibHologramProvider>();
    private MrLibHologramProvider activeProvider;

    private MrLibHologramManager() {
        this.setupProviders();
    }

    public static MrLibHologramManager getInstance() {
        if (instance == null) {
            instance = new MrLibHologramManager();
        }
        return instance;
    }

    private void setupProviders() {
        Plugin mrLibCorePlugin = Bukkit.getPluginManager().getPlugin("MrLibCore");
        MrLibNativeHologramProvider nativeProvider = new MrLibNativeHologramProvider();
        MrLibEntityHologramProvider entityProvider = new MrLibEntityHologramProvider(mrLibCorePlugin);
        this.providers.put("MrLibCore", entityProvider);
        this.providers.put("MrLibCore-Entity", entityProvider);
        this.providers.put("DecentHolograms", entityProvider);
        this.providers.put("CMI", entityProvider);
        this.providers.put("CMIHolograms", entityProvider);
        if (entityProvider.isEnabled()) {
            this.activeProvider = entityProvider;
            MrLibConsoleSayer.MrSay_Success("Hologram support enabled: " + entityProvider.getProviderName() + " (Entity Provider for all)");
            return;
        }
        this.activeProvider = nativeProvider;
        MrLibConsoleSayer.MrSay_Success("Hologram support enabled: MrLibCore Native (fallback)");
    }

    public boolean setProvider(String providerName) {
        MrLibHologramProvider provider = this.providers.get(providerName);
        if (provider != null && provider.isEnabled()) {
            this.activeProvider = provider;
            MrLibConsoleSayer.MrSay_Success("Hologram provider set to: " + provider.getProviderName());
            return true;
        }
        MrLibConsoleSayer.MrSay_Warning("Failed to set hologram provider to: " + providerName + " (not found or disabled)");
        return false;
    }

    public boolean isEnabled() {
        return this.activeProvider != null;
    }

    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        List<String> filteredLines = this.filterHologramLines(lines);
        this.activeProvider.createHologram(name, location, filteredLines);
    }

    public void updateHologram(String name, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        List<String> filteredLines = this.filterHologramLines(lines);
        this.activeProvider.updateHologram(name, filteredLines);
    }

    public void deleteHologram(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.activeProvider.deleteHologram(name);
    }

    public void cleanupAllHolograms() {
        if (this.activeProvider instanceof MrLibNativeHologramProvider) {
            ((MrLibNativeHologramProvider)this.activeProvider).cleanupAllHolograms();
        } else if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            ((MrLibEntityHologramProvider)this.activeProvider).cleanupAllHolograms();
        }
    }

    public boolean hologramExists(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.activeProvider.hologramExists(name);
    }

    public boolean has(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.activeProvider.hologramExists(name);
    }

    public String getActiveProviderName() {
        if (this.activeProvider == null) {
            return null;
        }
        return this.activeProvider.getProviderName();
    }

    public MrLibHologramProvider getActiveProvider() {
        return this.activeProvider;
    }

    public void createItemHologram(String name, Location location, ItemStack item, boolean withGlass, boolean rotate) {
        MrLibHologramProvider nativeProvider = this.providers.get("MrLibCore");
        if (nativeProvider instanceof MrLibNativeHologramProvider) {
            ((MrLibNativeHologramProvider)nativeProvider).createItemHologram(name, location, item, withGlass, rotate);
        }
    }

    public void updateItemHologram(String name, ItemStack item) {
        MrLibHologramProvider nativeProvider = this.providers.get("MrLibCore");
        if (nativeProvider instanceof MrLibNativeHologramProvider) {
            ((MrLibNativeHologramProvider)nativeProvider).updateItemHologram(name, item);
        }
    }

    public String getEntityHologramPerformanceStats() {
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            return ((MrLibEntityHologramProvider)this.activeProvider).getPerformanceStats();
        }
        return null;
    }

    public void forceUpdateAllEntityHolograms() {
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            ((MrLibEntityHologramProvider)this.activeProvider).forceUpdateAll();
        }
    }

    public boolean isUsingEntityProvider() {
        return this.activeProvider instanceof MrLibEntityHologramProvider;
    }

    public void shutdown() {
        this.cleanupAllHolograms();
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            ((MrLibEntityHologramProvider)this.activeProvider).shutdown();
        }
        this.providers.clear();
        this.activeProvider = null;
        instance = null;
    }

    private List<String> filterHologramLines(List<String> lines) {
        if (lines == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> filteredLines = new ArrayList<String>();
        for (String line : lines) {
            if (line == null) continue;
            String filteredLine = line.replace("(!message!)", "");
            filteredLines.add(filteredLine);
        }
        return filteredLines;
    }
}

