/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.entities;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class MrLibEntityHologram {
    private final String name;
    private final Location baseLocation;
    private final List<String> lines;
    private final List<TextDisplay> entities;
    private final Plugin plugin;
    private long lastUpdate = 0L;
    private boolean needsUpdate = false;
    private boolean isVisible = false;
    private final Set<UUID> nearbyPlayers = ConcurrentHashMap.newKeySet();
    private float textScale = 1.0f;
    private int backgroundColor = 0x40000000;
    private byte textOpacity = (byte)-1;
    private boolean hasBackground = true;
    private boolean hasShadow = true;
    private boolean seeThrough = false;
    private static final double VIEW_DISTANCE = 64.0;
    private static final double UPDATE_DISTANCE = 32.0;
    private static final long UPDATE_INTERVAL = 20L;
    private static final double LINE_SPACING = 0.3;

    public MrLibEntityHologram(String name, Location location, List<String> lines, Plugin plugin) {
        this.name = name;
        this.baseLocation = location.clone();
        this.lines = new ArrayList<String>(lines);
        this.entities = new ArrayList<TextDisplay>();
        this.plugin = plugin;
        this.createEntities();
    }

    public MrLibEntityHologram(String name, Location location, List<String> lines, Plugin plugin, float textScale, int backgroundColor, boolean hasBackground, boolean hasShadow) {
        this.name = name;
        this.baseLocation = location.clone();
        this.lines = new ArrayList<String>(lines);
        this.entities = new ArrayList<TextDisplay>();
        this.plugin = plugin;
        this.textScale = textScale;
        this.backgroundColor = backgroundColor;
        this.hasBackground = hasBackground;
        this.hasShadow = hasShadow;
        this.createEntities();
    }

    private void createEntities() {
        if (this.baseLocation.getWorld() == null) {
            return;
        }
        this.clearEntities();
        double yOffset = -2.2 + (double)this.lines.size() * 0.3;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            if (line == null || line.trim().isEmpty()) continue;
            Location lineLocation = this.baseLocation.clone().add(0.0, yOffset, 0.0);
            TextDisplay entity = this.createOptimizedTextDisplay(lineLocation, line);
            this.entities.add(entity);
            yOffset -= 0.3;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    private TextDisplay createOptimizedTextDisplay(Location location, String text) {
        TextDisplay entity = (TextDisplay)location.getWorld().spawnEntity(location, EntityType.TEXT_DISPLAY);
        if (text.length() > 512) {
            text = text.substring(0, 512);
        }
        entity.setText(MrLibColors.colorize(text));
        entity.setLineWidth(Integer.MAX_VALUE);
        entity.setBillboard(Display.Billboard.CENTER);
        entity.setSeeThrough(this.seeThrough);
        entity.setShadowed(this.hasShadow);
        entity.setDefaultBackground(this.hasBackground);
        if (this.hasBackground) {
            entity.setBackgroundColor(Color.fromARGB((int)this.backgroundColor));
        }
        entity.setTextOpacity(this.textOpacity);
        if (this.textScale != 1.0f) {
            Vector3f scale = new Vector3f(this.textScale, this.textScale, this.textScale);
            Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
            AxisAngle4f rotation = new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f);
            Transformation transformation = new Transformation(translation, rotation, scale, rotation);
            entity.setTransformation(transformation);
        }
        entity.setMetadata("mrlib_entity_hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this.name));
        entity.setMetadata("mrlib_display_hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        return entity;
    }

    public void updateLines(List<String> newLines) {
        if (newLines == null || newLines.equals(this.lines)) {
            return;
        }
        this.lines.clear();
        this.lines.addAll(newLines);
        this.needsUpdate = true;
    }

    public void performUpdate() {
        long currentTime = System.currentTimeMillis();
        if (!this.needsUpdate && currentTime - this.lastUpdate < 1000L) {
            return;
        }
        this.updateNearbyPlayers();
        if (this.nearbyPlayers.isEmpty()) {
            if (this.isVisible) {
                this.hideFromAllPlayers();
                this.isVisible = false;
            }
            return;
        }
        if (!this.isVisible) {
            this.showToNearbyPlayers();
            this.isVisible = true;
        }
        if (this.needsUpdate) {
            this.updateEntitiesSmooth();
            this.needsUpdate = false;
        }
        this.lastUpdate = currentTime;
    }

    private void updateNearbyPlayers() {
        this.nearbyPlayers.clear();
        if (this.baseLocation.getWorld() == null) {
            return;
        }
        for (Player player : this.baseLocation.getWorld().getPlayers()) {
            double distance = player.getLocation().distance(this.baseLocation);
            if (!(distance <= 64.0)) continue;
            this.nearbyPlayers.add(player.getUniqueId());
        }
    }

    private void updateEntitiesSmooth() {
        while (this.entities.size() < this.lines.size()) {
            this.entities.add(null);
        }
        while (this.entities.size() > this.lines.size()) {
            TextDisplay entity = this.entities.remove(this.entities.size() - 1);
            if (entity == null || entity.isDead()) continue;
            entity.remove();
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            TextDisplay entity = this.entities.get(i);
            if (line == null || line.trim().isEmpty()) {
                if (entity == null || entity.isDead()) continue;
                entity.remove();
                this.entities.set(i, null);
                continue;
            }
            if (entity == null || entity.isDead()) {
                Location entityLoc = this.baseLocation.clone().add(0.0, (double)(-i) * 0.3, 0.0);
                entity = this.createOptimizedTextDisplay(entityLoc, line);
                this.entities.set(i, entity);
                continue;
            }
            String colorizedLine = MrLibColors.colorize(line);
            if (colorizedLine.length() > 512) {
                colorizedLine = colorizedLine.substring(0, 512);
            }
            if (!colorizedLine.equals(entity.getText())) {
                entity.setText(colorizedLine);
            }
            Location expectedLoc = this.baseLocation.clone().add(0.0, (double)(-i) * 0.3, 0.0);
            if (!(entity.getLocation().distance(expectedLoc) > 0.1)) continue;
            entity.teleport(expectedLoc);
        }
    }

    private void showToNearbyPlayers() {
        for (TextDisplay entity : this.entities) {
            if (entity == null || entity.isDead()) continue;
            entity.setViewRange(64.0f);
        }
    }

    private void hideFromAllPlayers() {
        for (TextDisplay entity : this.entities) {
            if (entity == null || entity.isDead()) continue;
            entity.setViewRange(0.0f);
        }
    }

    public boolean hasNearbyPlayers() {
        if (this.baseLocation.getWorld() == null) {
            return false;
        }
        for (Player player : this.baseLocation.getWorld().getPlayers()) {
            if (!(player.getLocation().distance(this.baseLocation) <= 32.0)) continue;
            return true;
        }
        return false;
    }

    private void clearEntities() {
        for (TextDisplay entity : this.entities) {
            if (entity == null || entity.isDead()) continue;
            entity.remove();
        }
        this.entities.clear();
    }

    public void remove() {
        this.clearEntities();
        this.nearbyPlayers.clear();
    }

    public boolean isValid() {
        return this.baseLocation.getWorld() != null && !this.entities.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.baseLocation.clone();
    }

    public List<String> getLines() {
        return new ArrayList<String>(this.lines);
    }

    public int getNearbyPlayerCount() {
        return this.nearbyPlayers.size();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setTextScale(float scale) {
        this.textScale = scale;
        this.updateDisplayProperties();
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        this.updateDisplayProperties();
    }

    public void setHasBackground(boolean hasBackground) {
        this.hasBackground = hasBackground;
        this.updateDisplayProperties();
    }

    public void setHasShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
        this.updateDisplayProperties();
    }

    public void setTextOpacity(byte opacity) {
        this.textOpacity = opacity;
        this.updateDisplayProperties();
    }

    public void setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        this.updateDisplayProperties();
    }

    private void updateDisplayProperties() {
        for (TextDisplay entity : this.entities) {
            if (entity == null || entity.isDead()) continue;
            entity.setDefaultBackground(this.hasBackground);
            if (this.hasBackground) {
                entity.setBackgroundColor(Color.fromARGB((int)this.backgroundColor));
            }
            entity.setShadowed(this.hasShadow);
            entity.setSeeThrough(this.seeThrough);
            entity.setTextOpacity(this.textOpacity);
            if (this.textScale == 1.0f) continue;
            Vector3f scale = new Vector3f(this.textScale, this.textScale, this.textScale);
            Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
            AxisAngle4f rotation = new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f);
            Transformation transformation = new Transformation(translation, rotation, scale, rotation);
            entity.setTransformation(transformation);
        }
    }

    public float getTextScale() {
        return this.textScale;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean hasBackground() {
        return this.hasBackground;
    }

    public boolean hasShadow() {
        return this.hasShadow;
    }

    public byte getTextOpacity() {
        return this.textOpacity;
    }

    public boolean isSeeThrough() {
        return this.seeThrough;
    }
}

