/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.entities;

import eu.mrneznamy.mrlibcore.holograms.entities.MrLibEntityHologram;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MrLibEntityHologramManager {
    private static MrLibEntityHologramManager instance;
    private final Map<String, MrLibEntityHologram> holograms = new ConcurrentHashMap<String, MrLibEntityHologram>();
    private final Plugin plugin;
    private BukkitTask updateTask;
    private BukkitTask cleanupTask;
    private long totalUpdates = 0L;
    private long totalHologramsProcessed = 0L;
    private long lastPerformanceCheck = System.currentTimeMillis();

    public MrLibEntityHologramManager(Plugin plugin) {
        this.plugin = plugin;
        this.startUpdateTask();
        this.startCleanupTask();
    }

    public static MrLibEntityHologramManager getInstance(Plugin plugin) {
        if (instance == null) {
            instance = new MrLibEntityHologramManager(plugin);
        }
        return instance;
    }

    public static MrLibEntityHologramManager getInstance() {
        return instance;
    }

    public void createHologram(String name, Location location, List<String> lines) {
        if (name == null || location == null || lines == null) {
            return;
        }
        this.removeHologram(name);
        MrLibEntityHologram hologram = new MrLibEntityHologram(name, location, lines, this.plugin);
        this.holograms.put(name, hologram);
    }

    public void updateHologram(String name, List<String> lines) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.updateLines(lines);
        }
    }

    public void createHologram(String name, Location location, List<String> lines, float textScale, int backgroundColor, boolean hasBackground, boolean hasShadow) {
        if (name == null || location == null || lines == null) {
            return;
        }
        this.removeHologram(name);
        MrLibEntityHologram hologram = new MrLibEntityHologram(name, location, lines, this.plugin, textScale, backgroundColor, hasBackground, hasShadow);
        this.holograms.put(name, hologram);
    }

    public void setHologramTextScale(String name, float scale) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.setTextScale(scale);
        }
    }

    public void setHologramBackgroundColor(String name, int color) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.setBackgroundColor(color);
        }
    }

    public void setHologramBackground(String name, boolean hasBackground) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.setHasBackground(hasBackground);
        }
    }

    public void setHologramShadow(String name, boolean hasShadow) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.setHasShadow(hasShadow);
        }
    }

    public void setHologramTextOpacity(String name, byte opacity) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.setTextOpacity(opacity);
        }
    }

    public void setHologramSeeThrough(String name, boolean seeThrough) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        if (hologram != null && hologram.isValid()) {
            hologram.setSeeThrough(seeThrough);
        }
    }

    public void removeHologram(String name) {
        MrLibEntityHologram hologram = this.holograms.remove(name);
        if (hologram != null) {
            hologram.remove();
        }
    }

    public boolean hologramExists(String name) {
        MrLibEntityHologram hologram = this.holograms.get(name);
        return hologram != null && hologram.isValid();
    }

    public MrLibEntityHologram getHologram(String name) {
        return this.holograms.get(name);
    }

    public Set<String> getHologramNames() {
        return this.holograms.keySet();
    }

    public int getHologramCount() {
        return this.holograms.size();
    }

    private void startUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.updateTask = new BukkitRunnable(){

            public void run() {
                MrLibEntityHologramManager.this.performBatchUpdate();
            }
        }.runTaskTimer(this.plugin, 20L, 20L);
    }

    private void startCleanupTask() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        this.cleanupTask = new BukkitRunnable(){

            public void run() {
                MrLibEntityHologramManager.this.performCleanup();
            }
        }.runTaskTimer(this.plugin, 6000L, 6000L);
    }

    private void performBatchUpdate() {
        if (this.holograms.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        int processedCount = 0;
        for (MrLibEntityHologram hologram : this.holograms.values()) {
            if (hologram == null || !hologram.isValid() || !hologram.hasNearbyPlayers()) continue;
            hologram.performUpdate();
            ++processedCount;
        }
        ++this.totalUpdates;
        this.totalHologramsProcessed += (long)processedCount;
        long processingTime = System.currentTimeMillis() - startTime;
        if (processingTime > 50L) {
            Bukkit.getLogger().warning("[MrLibCore] Entity hologram batch update took " + processingTime + "ms for " + processedCount + " holograms");
        }
    }

    private void performCleanup() {
        long currentTime;
        int removedCount = 0;
        this.holograms.entrySet().removeIf(entry -> {
            MrLibEntityHologram hologram = (MrLibEntityHologram)entry.getValue();
            if (hologram == null || !hologram.isValid()) {
                if (hologram != null) {
                    hologram.remove();
                }
                return true;
            }
            return false;
        });
        if (removedCount > 0) {
            Bukkit.getLogger().info("[MrLibCore] Cleaned up " + removedCount + " invalid entity holograms");
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastPerformanceCheck > 300000L) {
            this.logPerformanceStatistics();
            this.lastPerformanceCheck = currentTime;
        }
    }

    private void logPerformanceStatistics() {
        if (this.totalUpdates > 0L) {
            double avgHologramsPerUpdate = (double)this.totalHologramsProcessed / (double)this.totalUpdates;
            Bukkit.getLogger().info(String.format("[MrLibCore] Entity Hologram Performance: %d total updates, %.1f avg holograms/update, %d active holograms", this.totalUpdates, avgHologramsPerUpdate, this.holograms.size()));
        }
    }

    public void removeAllHolograms() {
        for (MrLibEntityHologram hologram : this.holograms.values()) {
            if (hologram == null) continue;
            hologram.remove();
        }
        this.holograms.clear();
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
        this.removeAllHolograms();
        instance = null;
    }

    public String getPerformanceStats() {
        double avgHologramsPerUpdate = this.totalUpdates > 0L ? (double)this.totalHologramsProcessed / (double)this.totalUpdates : 0.0;
        return String.format("Entity Holograms: %d active, %d total updates, %.1f avg/update", this.holograms.size(), this.totalUpdates, avgHologramsPerUpdate);
    }

    public void forceUpdateAll() {
        for (MrLibEntityHologram hologram : this.holograms.values()) {
            if (hologram == null || !hologram.isValid()) continue;
            hologram.performUpdate();
        }
    }
}

