/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.utils;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;

public class MrLibColors {
    private static final List<String> legacyColors = Arrays.asList("&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "&f", "\u00a70", "\u00a71", "\u00a72", "\u00a73", "\u00a74", "\u00a75", "\u00a76", "\u00a77", "\u00a78", "\u00a79", "\u00a7a", "\u00a7b", "\u00a7c", "\u00a7d", "\u00a7e", "\u00a7f");
    private static final List<String> specialChars = Arrays.asList("&l", "&n", "&o", "&k", "&m", "&r", "\u00a7l", "\u00a7n", "\u00a7o", "\u00a7k", "\u00a7m", "\u00a7r");
    private static final Pattern patternNormal = Pattern.compile("\\{#([0-9A-Fa-f]{6})\\}");
    private static final Pattern patternGrad = Pattern.compile("\\{#([0-9A-Fa-f]{6})>\\}(.*?)\\{#([0-9A-Fa-f]{6})<\\}");
    private static final Pattern patternGradReverse = Pattern.compile("\\{#([0-9A-Fa-f]{6})<\\}(.*?)\\{#([0-9A-Fa-f]{6})>\\}");
    private static final Pattern patternOneFromTwo = Pattern.compile("\\{#([0-9A-Fa-f]{6})<>\\}");
    private static final Pattern patternAngleBrackets = Pattern.compile("<#([0-9A-Fa-f]{6})>");
    private static final Pattern patternHashOnly = Pattern.compile("(?<!\\{)(?<!<)#([0-9A-Fa-f]{6})(?!\\})(?!>)");
    private static final Pattern patternHtmlStyle = Pattern.compile("<#([0-9A-Fa-f]{6})>(.*?)</#([0-9A-Fa-f]{6})>");
    private static boolean placeholderAPIAvailable = false;

    public static String colorize(String input, Player player) {
        if (input == null) {
            return null;
        }
        if (placeholderAPIAvailable && player != null) {
            input = MrLibColors.applyPlaceholders(input, player);
        }
        input = MrLibColors.colorizeGradient(input);
        input = MrLibColors.colorizeRGB(input);
        input = MrLibColors.colorizeNewFormats(input);
        input = ChatColor.translateAlternateColorCodes((char)'&', (String)input);
        return input;
    }

    public static String colorize(String input) {
        return MrLibColors.colorize(input, null);
    }

    private static String applyPlaceholders(String input, Player player) {
        try {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)input);
        }
        catch (Exception e) {
            return input;
        }
    }

    private static String colorizeNewFormats(String input) {
        Matcher htmlMatcher = patternHtmlStyle.matcher(input);
        while (htmlMatcher.find()) {
            String startColor = htmlMatcher.group(1);
            String text = htmlMatcher.group(2);
            String endColor = htmlMatcher.group(3);
            if (startColor.equals(endColor)) {
                String colored = String.valueOf(ChatColor.of((String)("#" + startColor))) + text;
                input = input.replace(htmlMatcher.group(), colored);
                continue;
            }
            String gradient = MrLibColors.color(text, new Color(Integer.parseInt(startColor, 16)), new Color(Integer.parseInt(endColor, 16)));
            input = input.replace(htmlMatcher.group(), gradient);
        }
        Matcher angleMatcher = patternAngleBrackets.matcher(input);
        while (angleMatcher.find()) {
            String color = angleMatcher.group(1);
            input = input.replace(angleMatcher.group(), String.valueOf(MrLibColors.getColor(color)));
        }
        Matcher hashMatcher = patternHashOnly.matcher(input);
        while (hashMatcher.find()) {
            String color = hashMatcher.group(1);
            input = input.replace("#" + color, String.valueOf(MrLibColors.getColor(color)));
        }
        return input;
    }

    public static String sbcolorize(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String clear(String input) {
        input = MrLibColors.removePatterns(input);
        input = MrLibColors.removeLegacyColors(input);
        input = MrLibColors.removeSpecialChars(input);
        return input;
    }

    public static String stripColor(String input) {
        return MrLibColors.clear(input);
    }

    public static String removeSpecialChars(String input) {
        for (String chars : specialChars) {
            if (!input.contains(chars)) continue;
            input = input.replaceAll(Pattern.quote(chars), "");
        }
        return input;
    }

    public static String removeLegacyColors(String input) {
        for (String color : legacyColors) {
            if (!input.contains(color)) continue;
            input = input.replaceAll(Pattern.quote(color), "");
        }
        return input;
    }

    public static String removePatterns(String input) {
        input = input.replaceAll("\\{#([0-9A-Fa-f]{6})>\\}", "");
        input = input.replaceAll("\\{#([0-9A-Fa-f]{6})<\\}", "");
        input = input.replaceAll("\\{#([0-9A-Fa-f]{6})\\}", "");
        input = input.replaceAll("<#([0-9A-Fa-f]{6})>", "");
        input = input.replaceAll("</#([0-9A-Fa-f]{6})>", "");
        input = input.replaceAll("#([0-9A-Fa-f]{6})", "");
        return input;
    }

    public static String colorizeClassic(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String colorizeGradient(String input) {
        Matcher oneFromTwoMatcher = patternOneFromTwo.matcher(input);
        StringBuffer output = new StringBuffer();
        while (oneFromTwoMatcher.find()) {
            String text = oneFromTwoMatcher.group(1);
            oneFromTwoMatcher.appendReplacement(output, "{#" + text + "<}{#" + text + ">}");
        }
        oneFromTwoMatcher.appendTail(output);
        input = output.toString();
        Matcher gradMatcher = patternGrad.matcher(input);
        while (gradMatcher.find()) {
            String text = gradMatcher.group(2);
            Color startColor = new Color(Integer.parseInt(gradMatcher.group(1), 16));
            Color endColor = new Color(Integer.parseInt(gradMatcher.group(3), 16));
            input = input.replace(gradMatcher.group(), MrLibColors.color(text, startColor, endColor));
        }
        Matcher gradReverseMatcher = patternGradReverse.matcher(input);
        while (gradReverseMatcher.find()) {
            String text = gradReverseMatcher.group(2);
            Color startColor = new Color(Integer.parseInt(gradReverseMatcher.group(1), 16));
            Color endColor = new Color(Integer.parseInt(gradReverseMatcher.group(3), 16));
            input = input.replace(gradReverseMatcher.group(), MrLibColors.color(text, startColor, endColor));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String colorizeRGB(String input) {
        Matcher matcher = patternNormal.matcher(input);
        while (matcher.find()) {
            String color = matcher.group(1);
            input = input.replace(matcher.group(), String.valueOf(MrLibColors.getColor(color)));
        }
        return input;
    }

    public static String color(String input, Color first, Color second) {
        ChatColor[] colors = MrLibColors.createGradient(first, second, MrLibColors.removeSpecialChars(input).length());
        return MrLibColors.apply(input, colors);
    }

    private static String apply(String input, ChatColor[] colors) {
        StringBuilder specialColors = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String[] characters = input.split("");
        int outIndex = 0;
        for (int i = 0; i < characters.length; ++i) {
            if (!characters[i].equals("&") && !characters[i].equals("\u00a7")) {
                if (outIndex < colors.length) {
                    stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                    continue;
                }
                stringBuilder.append(characters[i]);
                continue;
            }
            if (i + 1 >= characters.length) {
                if (outIndex < colors.length) {
                    stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                    continue;
                }
                stringBuilder.append(characters[i]);
                continue;
            }
            if (characters[i + 1].equals("r")) {
                specialColors.setLength(0);
            } else {
                specialColors.append(characters[i]);
                specialColors.append(characters[i + 1]);
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    private static ChatColor[] createGradient(Color first, Color second, int amount) {
        if (amount <= 0) {
            amount = 1;
        }
        ChatColor[] colors = new ChatColor[amount];
        if (amount == 1) {
            colors[0] = ChatColor.of((Color)first);
            return colors;
        }
        int amountR = Math.abs(first.getRed() - second.getRed()) / (amount - 1);
        int amountG = Math.abs(first.getGreen() - second.getGreen()) / (amount - 1);
        int amountB = Math.abs(first.getBlue() - second.getBlue()) / (amount - 1);
        int[] colorDir = new int[]{first.getRed() < second.getRed() ? 1 : -1, first.getGreen() < second.getGreen() ? 1 : -1, first.getBlue() < second.getBlue() ? 1 : -1};
        for (int i = 0; i < amount; ++i) {
            int r = Math.max(0, Math.min(255, first.getRed() + amountR * i * colorDir[0]));
            int g = Math.max(0, Math.min(255, first.getGreen() + amountG * i * colorDir[1]));
            int b = Math.max(0, Math.min(255, first.getBlue() + amountB * i * colorDir[2]));
            colors[i] = ChatColor.of((Color)new Color(r, g, b));
        }
        return colors;
    }

    public static ChatColor getColor(String hex) {
        return ChatColor.of((Color)new Color(Integer.parseInt(hex, 16)));
    }

    public static boolean isPlaceholderAPIAvailable() {
        return placeholderAPIAvailable;
    }

    static {
        try {
            Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            placeholderAPIAvailable = true;
        }
        catch (ClassNotFoundException e) {
            placeholderAPIAvailable = false;
        }
    }
}

