/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.utils;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibUpdater {
    private final JavaPlugin plugin;
    private final String modrinthSlug;
    private final File pluginFile;

    public MrLibUpdater(JavaPlugin plugin, String modrinthSlug) {
        this.plugin = plugin;
        this.modrinthSlug = modrinthSlug;
        this.pluginFile = this.getPluginFile();
    }

    public void checkAndUpdate() {
        if (!this.plugin.getConfig().getBoolean("settings.auto-update.enabled", false)) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String currentVersion = this.plugin.getDescription().getVersion();
                String[] versionData = this.fetchLatestVersionData();
                if (versionData == null) {
                    return;
                }
                String latestVersion = versionData[0];
                String downloadUrl = versionData[1];
                if (!this.isNewerVersion(latestVersion, currentVersion)) {
                    MrLibConsoleSayer.MrSay_Info("Plugin is up to date!");
                    return;
                }
                MrLibConsoleSayer.MrSay_Info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                MrLibConsoleSayer.MrSay_Info("\u2551  Downloading new version...            \u2551");
                MrLibConsoleSayer.MrSay_Info("\u2551  " + currentVersion + " \u2192 " + latestVersion + "                    \u2551");
                MrLibConsoleSayer.MrSay_Info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                if (this.downloadUpdate(downloadUrl)) {
                    this.deleteOldJar();
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        MrLibConsoleSayer.MrSay_Success("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                        MrLibConsoleSayer.MrSay_Success("\u2551  Update downloaded successfully!       \u2551");
                        MrLibConsoleSayer.MrSay_Success("\u2551  Old plugin deleted                    \u2551");
                        MrLibConsoleSayer.MrSay_Success("\u2551  Restart server to apply changes       \u2551");
                        MrLibConsoleSayer.MrSay_Success("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                    });
                } else {
                    MrLibConsoleSayer.MrSay_Error("Failed to download update!");
                }
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error("Auto-update failed: " + e.getMessage());
            }
        });
    }

    private String[] fetchLatestVersionData() {
        try {
            String line;
            HttpURLConnection conn = (HttpURLConnection)new URL("https://api.modrinth.com/v2/project/" + this.modrinthSlug + "/version").openConnection();
            conn.setRequestProperty("User-Agent", "MrLibCore-Updater");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            String json = response.toString();
            String version = json.split("\"version_number\":\"")[1].split("\"")[0];
            String url = json.split("\"url\":\"")[1].split("\"")[0];
            return new String[]{version, url};
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Failed to fetch version data: " + e.getMessage());
            return null;
        }
    }

    private boolean downloadUpdate(String downloadUrl) {
        try {
            URL url = new URL(downloadUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "MrLibCore-Updater");
            ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
            File updateFolder = new File(this.plugin.getDataFolder().getParentFile(), "update");
            if (!updateFolder.exists()) {
                updateFolder.mkdir();
            }
            File outputFile = new File(updateFolder, this.pluginFile.getName());
            FileOutputStream fos = new FileOutputStream(outputFile);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            rbc.close();
            MrLibConsoleSayer.MrSay_Info("Downloaded to: " + outputFile.getPath());
            return true;
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Download failed: " + e.getMessage());
            return false;
        }
    }

    private boolean isNewerVersion(String newVersion, String currentVersion) {
        try {
            String[] newParts = newVersion.replaceAll("[^0-9.]", "").split("\\.");
            String[] currentParts = currentVersion.replaceAll("[^0-9.]", "").split("\\.");
            int maxLength = Math.max(newParts.length, currentParts.length);
            for (int i = 0; i < maxLength; ++i) {
                int currentPart;
                int newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
                int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                if (newPart > currentPart) {
                    return true;
                }
                if (newPart >= currentPart) continue;
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return !newVersion.equals(currentVersion);
        }
    }

    private void deleteOldJar() {
        try {
            if (this.pluginFile != null && this.pluginFile.exists()) {
                if (this.pluginFile.delete()) {
                    MrLibConsoleSayer.MrSay_Info("Old plugin file deleted: " + this.pluginFile.getName());
                } else {
                    this.pluginFile.deleteOnExit();
                    MrLibConsoleSayer.MrSay_Warning("Old plugin marked for deletion on restart");
                }
            }
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Failed to delete old plugin: " + e.getMessage());
        }
    }

    private File getPluginFile() {
        try {
            return new File(this.plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            return new File("plugins", this.plugin.getName() + ".jar");
        }
    }
}

