/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore;

import eu.mrneznamy.mrlibcore.bstats.bukkit.Metrics;
import eu.mrneznamy.mrlibcore.commands.MrLibCoreCommand;
import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrlibcore.gui.MrLibGUIManager;
import eu.mrneznamy.mrlibcore.holograms.MrLibHologramFacade;
import eu.mrneznamy.mrlibcore.placeholders.MrLibPlaceholderExpansion;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibPluginUpdater;
import eu.mrneznamy.mrlibcore.utils.MrLibUpdateChecker;
import java.awt.Color;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MrLibCore
extends JavaPlugin {
    private static MrLibCore instance;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        MrLibVaultManager.getInstance();
        MrLibHologramFacade hologramFacade = MrLibHologramFacade.getInstance();
        String preferredProvider = this.getConfig().getString("hologram-provider");
        if (preferredProvider != null && !preferredProvider.isEmpty()) {
            hologramFacade.setPreferredProvider(preferredProvider);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new MrLibGUIManager(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new MrLibPlaceholderExpansion().register();
            MrLibConsoleSayer.MrSay_Success("PlaceholderAPI expansion registered!");
        }
        MrLibPluginUpdater.registerPlugin("MrLibCore", "mrlibcore");
        new MrLibUpdateChecker(this, "mrlibcore").fetchLatestVersion(version -> {
            if (version != null) {
                MrLibConsoleSayer.MrSay_Info("Latest version available: " + version);
            }
        });
        this.displayLogo();
        MrLibConsoleSayer.MrSay_Success("MrLibCore is starting up...");
        MrLibConsoleSayer.MrSay_Success("MrLibCore enabled!");
        try {
            if (this.getCommand("mrlibcore") != null) {
                MrLibCoreCommand cmd = new MrLibCoreCommand(this);
                this.getCommand("mrlibcore").setExecutor((CommandExecutor)cmd);
                this.getCommand("mrlibcore").setTabCompleter((TabCompleter)cmd);
            }
        }
        catch (Throwable cmd) {
            // empty catch block
        }
        int pluginId = 27873;
        Metrics metrics = new Metrics(this, pluginId);
    }

    public void onDisable() {
        try {
            MrLibHologramFacade hologramManager = MrLibHologramFacade.getInstance();
            if (hologramManager != null) {
                hologramManager.cleanupAllHolograms();
            }
            int removed = 0;
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof TextDisplay) || !entity.hasMetadata("MrLibCore-Hologram")) continue;
                    entity.remove();
                    ++removed;
                }
            }
            if (removed > 0) {
                MrLibConsoleSayer.MrSay_Info("Removed " + removed + " TextDisplay entities on shutdown");
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error cleaning up holograms: " + e.getMessage());
        }
        MrLibConsoleSayer.MrSay_Info("MrLibCore disabled!");
    }

    public static MrLibCore getInstance() {
        return instance;
    }

    private void displayLogo() {
        String[] lines;
        String logo = " /$$      /$$           /$$       /$$ /$$\n| $$$    /$$$          | $$      |__/| $$\n| $$$$  /$$$$  /$$$$$$ | $$       /$$| $$$$$$$\n| $$ $$/$$ $$ /$$__  $$| $$      | $$| $$__  $$\n| $$  $$$| $$| $$  \\__/| $$      | $$| $$  \\ $$\n| $$\\  $ | $$| $$      | $$      | $$| $$  | $$\n| $$ \\/  | $$| $$      | $$$$$$$$| $$| $$$$$$$/\n|__/     |__/|__/      |________/|__/|_______/";
        Color startColor = new Color(2107179);
        Color endColor = new Color(0xFCFFFE);
        String coloredLogo = MrLibColors.color(logo, startColor, endColor);
        for (String line : lines = coloredLogo.split("\n")) {
            MrLibConsoleSayer.MrSay_Info(line);
        }
    }
}

