/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore;

import eu.mrneznamy.mrlibcore.config.MrLibConfigDownloader;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibUpdateChecker;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibRegisterPlugin {
    private static final Map<String, RegisteredPlugin> registeredPlugins = new HashMap<String, RegisteredPlugin>();

    public static void register(JavaPlugin plugin, String modrinthSlug) {
        String name = plugin.getName();
        String version = plugin.getDescription().getVersion();
        RegisteredPlugin registered = new RegisteredPlugin(plugin, version, modrinthSlug);
        registeredPlugins.put(name, registered);
        MrLibConsoleSayer.MrSay_Success("Plugin connecting to MrLibCore: &e" + name + " &7v" + version);
        MrLibRegisterPlugin.downloadConfigs(plugin);
        MrLibRegisterPlugin.checkUpdates(plugin, modrinthSlug);
    }

    public static void register(JavaPlugin plugin) {
        String name = plugin.getName();
        String version = plugin.getDescription().getVersion();
        RegisteredPlugin registered = new RegisteredPlugin(plugin, version, null);
        registeredPlugins.put(name, registered);
        MrLibConsoleSayer.MrSay_Success("Plugin connecting to MrLibCore: &e" + name + " &7v" + version);
        MrLibRegisterPlugin.downloadConfigs(plugin);
    }

    private static void downloadConfigs(JavaPlugin plugin) {
        try {
            MrLibConfigDownloader downloader = new MrLibConfigDownloader(plugin);
            downloader.downloadConfigs();
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Warning("[" + plugin.getName() + "] Using local configuration files");
        }
    }

    private static void checkUpdates(JavaPlugin plugin, String modrinthSlug) {
        if (modrinthSlug == null || modrinthSlug.isEmpty()) {
            return;
        }
        MrLibUpdateChecker.checkAndPrintVersion(plugin, modrinthSlug);
    }

    public static void checkAllUpdates() {
        registeredPlugins.values().forEach(registered -> {
            if (registered.modrinthSlug != null) {
                MrLibRegisterPlugin.checkUpdates(registered.plugin, registered.modrinthSlug);
            }
        });
    }

    public static RegisteredPlugin getPlugin(String name) {
        return registeredPlugins.get(name);
    }

    public static Map<String, RegisteredPlugin> getAllPlugins() {
        return new HashMap<String, RegisteredPlugin>(registeredPlugins);
    }

    public static void unregister(String name) {
        registeredPlugins.remove(name);
    }

    private static String formatPluginName(String name) {
        return String.format("%-15s", name);
    }

    private static String formatVersion(String version) {
        return String.format("%-26s", version);
    }

    public static class RegisteredPlugin {
        private final JavaPlugin plugin;
        private final String version;
        private final String modrinthSlug;

        public RegisteredPlugin(JavaPlugin plugin, String version, String modrinthSlug) {
            this.plugin = plugin;
            this.version = version;
            this.modrinthSlug = modrinthSlug;
        }

        public JavaPlugin getPlugin() {
            return this.plugin;
        }

        public String getVersion() {
            return this.version;
        }

        public String getModrinthSlug() {
            return this.modrinthSlug;
        }

        public String getName() {
            return this.plugin.getName();
        }
    }
}

