/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.commands;

import eu.mrneznamy.mrlibcore.MrLibCore;
import eu.mrneznamy.mrlibcore.holograms.MrLibHologramFacade;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibPluginUpdater;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;

public class MrLibCoreCommand
implements TabExecutor,
CommandExecutor {
    private final MrLibCore plugin;

    public MrLibCoreCommand(MrLibCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("mrlibcore.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "MrLibCore debug commands:");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " holo [name]" + String.valueOf(ChatColor.GRAY) + " - spawn test hologram above you");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " holostats" + String.valueOf(ChatColor.GRAY) + " - show hologram stats");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " holoclear" + String.valueOf(ChatColor.GRAY) + " - remove all holograms");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " holopurge" + String.valueOf(ChatColor.GRAY) + " - detect & remove all TextDisplay entities");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " holovis" + String.valueOf(ChatColor.GRAY) + " - spawn a visible ArmorStand for name-tag test");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/" + label + " update <Plugin|All>" + String.valueOf(ChatColor.GRAY) + " - download plugin updates from Modrinth");
            return true;
        }
        String sub = args[0].toLowerCase();
        MrLibHologramFacade facade = MrLibHologramFacade.getInstance();
        switch (sub) {
            case "holo": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This subcommand can only be used by a player.");
                    return true;
                }
                Player p = (Player)sender;
                Location loc = p.getLocation().clone().add(0.0, 2.0, 0.0);
                Object name = args.length >= 2 ? args[1] : "mrlibcore_test_" + p.getName();
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("&e&lMrLibCore Hologram Test");
                lines.add("&aPlayer: &f" + p.getName());
                lines.add("&7Pos: &f" + String.format("%.1f, %.1f, %.1f", loc.getX(), loc.getY(), loc.getZ()));
                facade.createHologram((String)name, loc, lines);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawned test hologram '" + (String)name + "' at your position.");
                MrLibConsoleSayer.MrSay_Info("[Holograms] /mrlibcore holo -> name=" + (String)name + ", world=" + (loc.getWorld() != null ? loc.getWorld().getName() : "null") + ", x=" + loc.getX() + ", y=" + loc.getY() + ", z=" + loc.getZ());
                return true;
            }
            case "holostats": {
                String stats = facade.getEntityHologramPerformanceStats();
                if (stats == null) {
                    stats = "No entity provider active";
                }
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Hologram stats: " + String.valueOf(ChatColor.WHITE) + stats);
                return true;
            }
            case "holoclear": {
                facade.cleanupAllHolograms();
                sender.sendMessage(String.valueOf(ChatColor.RED) + "All holograms removed.");
                return true;
            }
            case "holopurge": {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Scanning all worlds for TextDisplay entities...");
                int removed = 0;
                int total = 0;
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        if (!(entity instanceof TextDisplay)) continue;
                        ++total;
                        if (!entity.hasMetadata("MrLibCore-Hologram")) continue;
                        entity.remove();
                        ++removed;
                    }
                }
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Scan complete!");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total TextDisplay entities: " + String.valueOf(ChatColor.WHITE) + total);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Removed (with MrLibCore metadata): " + String.valueOf(ChatColor.WHITE) + removed);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Remaining: " + String.valueOf(ChatColor.WHITE) + (total - removed));
                if (removed > 0) {
                    MrLibConsoleSayer.MrSay_Info("[Holograms] Purged " + removed + " TextDisplay entities");
                }
                return true;
            }
            case "holovis": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This subcommand can only be used by a player.");
                    return true;
                }
                Player p = (Player)sender;
                Location loc = p.getLocation().clone().add(0.0, 0.2, 0.0);
                try {
                    ArmorStand stand = (ArmorStand)p.getWorld().spawn(loc, ArmorStand.class, s -> {
                        s.setVisible(true);
                        s.setGravity(false);
                        s.setMarker(false);
                        s.setSmall(false);
                        s.setCustomNameVisible(true);
                        s.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aDEBUG &7(visible AS)"));
                    });
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawned a VISIBLE ArmorStand with name tag at your feet. If you can see its name, environment is fine.");
                }
                catch (Throwable t) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to spawn visible ArmorStand: " + t.getMessage());
                }
                return true;
            }
            case "update": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + label + " update <Plugin|All>");
                    return true;
                }
                String target = args[1];
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Starting plugin update process...");
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    int updated = 0;
                    if (target.equalsIgnoreCase("all")) {
                        updated = MrLibPluginUpdater.updateAllPlugins();
                    } else if (MrLibPluginUpdater.updatePlugin(target)) {
                        updated = 1;
                    }
                    int finalUpdated = updated;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (finalUpdated > 0) {
                            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2713 Plugins downloaded successfully!");
                            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u2713 Old versions removed");
                            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u26a0 Please restart the server to apply updates");
                            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Updated " + finalUpdated + " plugin(s)");
                        } else {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u2717 No plugins were updated");
                        }
                    });
                });
                return true;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use /" + label);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("mrlibcore.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            subs.add("holo");
            subs.add("holostats");
            subs.add("holoclear");
            subs.add("holopurge");
            subs.add("holovis");
            subs.add("update");
            return subs;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("update")) {
            ArrayList<String> options = new ArrayList<String>();
            options.add("All");
            options.addAll(MrLibPluginUpdater.getRegisteredPlugins().keySet());
            return options;
        }
        return Collections.emptyList();
    }
}

