/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.config;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibConfigMigrator {
    private final JavaPlugin plugin;
    private final Map<String, Integer> configVersions = new HashMap<String, Integer>();
    private final Map<String, List<MigrationStep>> migrations = new HashMap<String, List<MigrationStep>>();

    public MrLibConfigMigrator(JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupMigrations();
    }

    public void migrateConfig(String configType, int currentVersion, int targetVersion) {
        if (currentVersion >= targetVersion) {
            return;
        }
        String fileName = configType.equals("config") ? "config.yml" : "messages.yml";
        File configFile = new File(this.plugin.getDataFolder(), fileName);
        if (!configFile.exists()) {
            return;
        }
        MrLibConsoleSayer.MrSay_Info("[" + this.plugin.getName() + "] Migrating " + fileName + " from v" + currentVersion + " to v" + targetVersion);
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            for (int version = currentVersion + 1; version <= targetVersion; ++version) {
                List<MigrationStep> steps = this.migrations.get(configType + "_v" + version);
                if (steps == null) continue;
                for (MigrationStep step : steps) {
                    step.apply((FileConfiguration)config);
                }
            }
            config.save(configFile);
            MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Successfully migrated " + fileName + " to v" + targetVersion);
        }
        catch (IOException e) {
            MrLibConsoleSayer.MrSay_Error("[" + this.plugin.getName() + "] Failed to migrate " + fileName + ": " + e.getMessage());
        }
    }

    public void checkAndMigrate() {
        File messagesFile;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (configFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            int currentVersion = config.getInt("config-version", 1);
            int targetVersion = this.configVersions.getOrDefault("config", 1);
            this.migrateConfig("config", currentVersion, targetVersion);
        }
        if ((messagesFile = new File(this.plugin.getDataFolder(), "messages.yml")).exists()) {
            YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
            int currentVersion = messages.getInt("messages-version", 1);
            int targetVersion = this.configVersions.getOrDefault("messages", 1);
            this.migrateConfig("messages", currentVersion, targetVersion);
        }
    }

    private void setupMigrations() {
        if (this.plugin.getName().equals("MrSellChests")) {
            this.setupMrSellChestsMigrations();
        } else if (this.plugin.getName().equals("MrUltimateFishing")) {
            this.setupMrUltimateFishingMigrations();
        } else if (this.plugin.getName().equals("MrUltimateShop")) {
            this.setupMrUltimateShopMigrations();
        }
    }

    private void setupMrSellChestsMigrations() {
        this.configVersions.put("config", 2);
        this.configVersions.put("messages", 2);
        ArrayList<MigrationStep> configV2 = new ArrayList<MigrationStep>();
        configV2.add(config -> {
            if (!config.contains("MrSellChests.Database")) {
                config.set("MrSellChests.Database.Type", (Object)"yml");
                config.set("MrSellChests.Database.Host", (Object)"localhost");
                config.set("MrSellChests.Database.Port", (Object)3306);
                config.set("MrSellChests.Database.Database", (Object)"minecraft");
                config.set("MrSellChests.Database.Username", (Object)"root");
                config.set("MrSellChests.Database.Password", (Object)"password");
            }
            config.set("config-version", (Object)2);
        });
        this.migrations.put("config_v2", configV2);
        ArrayList<MigrationStep> messagesV2 = new ArrayList<MigrationStep>();
        messagesV2.add(config -> {
            if (!config.contains("database_connection_failed")) {
                config.set("database_connection_failed", (Object)"&cDatabase connection failed! Using YAML storage.");
            }
            if (!config.contains("database_connected")) {
                config.set("database_connected", (Object)"&aConnected to database successfully!");
            }
            config.set("messages-version", (Object)2);
        });
        this.migrations.put("messages_v2", messagesV2);
    }

    private void setupMrUltimateFishingMigrations() {
        this.configVersions.put("config", 2);
        this.configVersions.put("messages", 2);
        ArrayList<MigrationStep> configV2 = new ArrayList<MigrationStep>();
        configV2.add(config -> {
            if (!config.contains("Database")) {
                config.set("Database.Type", (Object)"yml");
                config.set("Database.Host", (Object)"localhost");
                config.set("Database.Port", (Object)3306);
                config.set("Database.Database", (Object)"minecraft");
                config.set("Database.Username", (Object)"root");
                config.set("Database.Password", (Object)"password");
            }
            config.set("config-version", (Object)2);
        });
        this.migrations.put("config_v2", configV2);
        ArrayList<MigrationStep> messagesV2 = new ArrayList<MigrationStep>();
        messagesV2.add(config -> {
            if (!config.contains("database_connection_failed")) {
                config.set("database_connection_failed", (Object)"&cDatabase connection failed! Using YAML storage.");
            }
            if (!config.contains("database_connected")) {
                config.set("database_connected", (Object)"&aConnected to database successfully!");
            }
            config.set("messages-version", (Object)2);
        });
        this.migrations.put("messages_v2", messagesV2);
    }

    private void setupMrUltimateShopMigrations() {
        this.configVersions.put("config", 2);
        this.configVersions.put("messages", 2);
        ArrayList<MigrationStep> configV2 = new ArrayList<MigrationStep>();
        configV2.add(config -> {
            if (!config.contains("Database")) {
                config.set("Database.Type", (Object)"yml");
                config.set("Database.Host", (Object)"localhost");
                config.set("Database.Port", (Object)3306);
                config.set("Database.Database", (Object)"minecraft");
                config.set("Database.Username", (Object)"root");
                config.set("Database.Password", (Object)"password");
            }
            config.set("config-version", (Object)2);
        });
        this.migrations.put("config_v2", configV2);
        ArrayList<MigrationStep> messagesV2 = new ArrayList<MigrationStep>();
        messagesV2.add(config -> {
            if (!config.contains("database_connection_failed")) {
                config.set("database_connection_failed", (Object)"&cDatabase connection failed! Using YAML storage.");
            }
            if (!config.contains("database_connected")) {
                config.set("database_connected", (Object)"&aConnected to database successfully!");
            }
            config.set("messages-version", (Object)2);
        });
        this.migrations.put("messages_v2", messagesV2);
    }

    @FunctionalInterface
    public static interface MigrationStep {
        public void apply(FileConfiguration var1);
    }
}

