/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibEntityHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibTextDisplayHologramProvider;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class MrLibHologramFacade {
    private static MrLibHologramFacade instance;
    private final Map<String, MrLibHologramProvider> providers = new HashMap<String, MrLibHologramProvider>();
    private MrLibHologramProvider activeProvider;
    private String preferredProvider = null;

    private MrLibHologramFacade() {
        this.setupProviders();
    }

    public static MrLibHologramFacade getInstance() {
        if (instance == null) {
            instance = new MrLibHologramFacade();
        }
        return instance;
    }

    public void setPreferredProvider(String providerName) {
        this.preferredProvider = providerName;
        this.setupProviders();
    }

    private void setupProviders() {
        MrLibHologramProvider textDisplayProvider;
        Plugin mrLibCorePlugin = Bukkit.getPluginManager().getPlugin("MrLibCore");
        this.providers.clear();
        this.providers.put("MrLibCore-Entity", new MrLibEntityHologramProvider(mrLibCorePlugin));
        this.providers.put("MrLibCore-TextDisplay", new MrLibTextDisplayHologramProvider(mrLibCorePlugin));
        if (this.preferredProvider != null && !this.preferredProvider.isEmpty()) {
            MrLibHologramProvider preferred = this.providers.get(this.preferredProvider);
            if (preferred != null && preferred.isEnabled()) {
                this.activeProvider = preferred;
                MrLibConsoleSayer.MrSay_Success("Hologram support enabled: " + this.preferredProvider);
                return;
            }
            MrLibConsoleSayer.MrSay_Warning("Preferred hologram provider '" + this.preferredProvider + "' not available, trying alternatives...");
        }
        if ((textDisplayProvider = this.providers.get("MrLibCore-TextDisplay")) != null && textDisplayProvider.isEnabled()) {
            this.activeProvider = textDisplayProvider;
            MrLibConsoleSayer.MrSay_Success("Hologram support enabled: MrLibCore-TextDisplay (auto-detected)");
            return;
        }
        MrLibHologramProvider entityProvider = this.providers.get("MrLibCore-Entity");
        if (entityProvider != null && entityProvider.isEnabled()) {
            this.activeProvider = entityProvider;
            MrLibConsoleSayer.MrSay_Success("Hologram support enabled: MrLibCore-Entity (fallback)");
            return;
        }
        this.activeProvider = null;
        MrLibConsoleSayer.MrSay_Warning("Hologram support disabled: No providers available");
    }

    public boolean setProvider(String providerName) {
        MrLibHologramProvider provider = this.providers.get(providerName);
        if (provider != null && provider.isEnabled()) {
            this.activeProvider = provider;
            MrLibConsoleSayer.MrSay_Success("Hologram provider set to: " + providerName);
            return true;
        }
        MrLibConsoleSayer.MrSay_Warning("Failed to set hologram provider: " + providerName + " (not available)");
        return false;
    }

    public boolean isEnabled() {
        return this.activeProvider != null;
    }

    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        List<String> filteredLines = this.filterHologramLines(lines);
        try {
            boolean debug;
            Plugin p = Bukkit.getPluginManager().getPlugin("MrLibCore");
            boolean bl = debug = p != null && p.getConfig().getBoolean("debug-holograms", false);
            if (debug) {
                String prov = this.activeProvider != null ? this.activeProvider.getProviderName() : "null";
                String world = location != null && location.getWorld() != null ? location.getWorld().getName() : "null";
                MrLibConsoleSayer.MrSay_Info("[Holograms-Facade] create name='" + name + "' provider=" + prov + " world=" + world + " loc=" + (location != null ? String.format("(%.2f, %.2f, %.2f)", location.getX(), location.getY(), location.getZ()) : "null") + " lines=" + (filteredLines != null ? filteredLines.size() : 0));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activeProvider.createHologram(name, location, filteredLines);
    }

    public void updateHologram(String name, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        List<String> filteredLines = this.filterHologramLines(lines);
        try {
            boolean debug;
            Plugin p = Bukkit.getPluginManager().getPlugin("MrLibCore");
            boolean bl = debug = p != null && p.getConfig().getBoolean("debug-holograms", false);
            if (debug) {
                String prov = this.activeProvider != null ? this.activeProvider.getProviderName() : "null";
                MrLibConsoleSayer.MrSay_Info("[Holograms-Facade] update name='" + name + "' provider=" + prov + " lines=" + (filteredLines != null ? filteredLines.size() : 0));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activeProvider.updateHologram(name, filteredLines);
    }

    public void deleteHologram(String name) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            boolean debug;
            Plugin p = Bukkit.getPluginManager().getPlugin("MrLibCore");
            boolean bl = debug = p != null && p.getConfig().getBoolean("debug-holograms", false);
            if (debug) {
                String prov = this.activeProvider != null ? this.activeProvider.getProviderName() : "null";
                MrLibConsoleSayer.MrSay_Info("[Holograms-Facade] delete name='" + name + "' provider=" + prov);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activeProvider.deleteHologram(name);
    }

    public void cleanupAllHolograms() {
        try {
            boolean debug;
            Plugin p = Bukkit.getPluginManager().getPlugin("MrLibCore");
            boolean bl = debug = p != null && p.getConfig().getBoolean("debug-holograms", false);
            if (debug) {
                MrLibConsoleSayer.MrSay_Info("[Holograms-Facade] cleanupAllHolograms invoked");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            ((MrLibEntityHologramProvider)this.activeProvider).cleanupAllHolograms();
        } else if (this.activeProvider instanceof MrLibTextDisplayHologramProvider) {
            ((MrLibTextDisplayHologramProvider)this.activeProvider).cleanupAllHolograms();
        }
    }

    public boolean hologramExists(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.activeProvider.hologramExists(name);
    }

    public boolean has(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.activeProvider.hologramExists(name);
    }

    public String getActiveProviderName() {
        if (this.activeProvider == null) {
            return null;
        }
        return this.activeProvider.getProviderName();
    }

    public MrLibHologramProvider getActiveProvider() {
        return this.activeProvider;
    }

    public String getEntityHologramPerformanceStats() {
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            return ((MrLibEntityHologramProvider)this.activeProvider).getPerformanceStats();
        }
        return null;
    }

    public void forceUpdateAllEntityHolograms() {
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            ((MrLibEntityHologramProvider)this.activeProvider).forceUpdateAll();
        }
    }

    public boolean isUsingEntityProvider() {
        return this.activeProvider instanceof MrLibEntityHologramProvider;
    }

    public void shutdown() {
        this.cleanupAllHolograms();
        if (this.activeProvider instanceof MrLibEntityHologramProvider) {
            ((MrLibEntityHologramProvider)this.activeProvider).shutdown();
        } else if (this.activeProvider instanceof MrLibTextDisplayHologramProvider) {
            ((MrLibTextDisplayHologramProvider)this.activeProvider).shutdown();
        }
        this.providers.clear();
        this.activeProvider = null;
        instance = null;
    }

    private List<String> filterHologramLines(List<String> lines) {
        if (lines == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> filteredLines = new ArrayList<String>();
        for (String line : lines) {
            if (line == null) continue;
            String filteredLine = line.replaceAll("\\(!.*?\\)", "");
            filteredLines.add(filteredLine);
        }
        return filteredLines;
    }
}

