/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.displays;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MrLibTextDisplayHologramManager {
    private static MrLibTextDisplayHologramManager instance;
    private final Plugin plugin;
    private final Map<String, Hologram> holograms = new ConcurrentHashMap<String, Hologram>();
    private static final double LINE_SPACING = 0.25;

    public MrLibTextDisplayHologramManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public static MrLibTextDisplayHologramManager getInstance(Plugin plugin) {
        if (instance == null) {
            instance = new MrLibTextDisplayHologramManager(plugin);
        }
        return instance;
    }

    public static MrLibTextDisplayHologramManager getInstance() {
        return instance;
    }

    public void createHologram(String name, Location location, List<String> lines) {
        ArrayList<String> safeLines;
        if (name == null || location == null) {
            return;
        }
        ArrayList<String> arrayList = safeLines = lines != null ? new ArrayList<String>(lines) : new ArrayList();
        if (safeLines.isEmpty()) {
            safeLines.add("");
        }
        this.runSync(() -> {
            boolean debug = false;
            try {
                if (this.plugin != null) {
                    debug = this.plugin.getConfig().getBoolean("debug-holograms", false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (debug) {
                MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] create '" + name + "' at " + this.formatLoc(location) + " lines=" + safeLines.size());
                if (!safeLines.isEmpty()) {
                    try {
                        MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] first line: '" + (safeLines.get(0) == null ? "null" : (String)safeLines.get(0)) + "'");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.holograms.containsKey(name)) {
                    MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] Existing hologram found for '" + name + "', removing before create.");
                }
            }
            this.removeHologram(name);
            World world = location.getWorld();
            if (world == null) {
                MrLibConsoleSayer.MrSay_Warning("[Holograms-TextDisplay] World is null for hologram '" + name + "'. Skipping creation.");
                return;
            }
            ArrayList<TextDisplay> displays = new ArrayList<TextDisplay>();
            double y = location.getY();
            for (int i = 0; i < safeLines.size(); ++i) {
                String raw = safeLines.get(i) == null ? "" : (String)safeLines.get(i);
                String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
                Component text = this.deserialize(colored);
                Location lineLoc = new Location(world, location.getX(), y - (double)i * 0.25, location.getZ(), location.getYaw(), location.getPitch());
                TextDisplay td = null;
                try {
                    td = (TextDisplay)world.spawn(lineLoc, TextDisplay.class, display -> {
                        try {
                            display.setBillboard(Display.Billboard.CENTER);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            display.setAlignment(TextDisplay.TextAlignment.CENTER);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            display.setLineWidth(Integer.MAX_VALUE);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            display.setPersistent(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.setTextCompat((TextDisplay)display, colored, text);
                        if (this.plugin != null) {
                            try {
                                display.setMetadata("MrLibCore-Hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    MrLibConsoleSayer.MrSay_Error("[Holograms-TextDisplay] Failed to spawn TextDisplay for '" + name + "' line=" + i + " at " + this.formatLoc(lineLoc) + ": " + t.getMessage());
                }
                if (td != null && debug) {
                    try {
                        MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] spawned line=" + i + " uuid=" + String.valueOf(td.getUniqueId()) + " y=" + String.format("%.2f", lineLoc.getY()));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                displays.add(td);
            }
            this.holograms.put(name, new Hologram(location.clone(), displays));
            if (debug) {
                MrLibConsoleSayer.MrSay_Success("[Holograms-TextDisplay] created '" + name + "' entities=" + displays.size());
            }
        });
    }

    public void removeHologram(String name) {
        if (name == null) {
            return;
        }
        this.runSync(() -> {
            boolean debug = false;
            try {
                if (this.plugin != null) {
                    debug = this.plugin.getConfig().getBoolean("debug-holograms", false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Hologram holo = this.holograms.remove(name);
            if (holo != null) {
                if (debug) {
                    MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] remove '" + name + "' entities=" + holo.lines.size());
                }
                for (TextDisplay td : holo.lines) {
                    try {
                        td.remove();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    public void updateHologram(String name, List<String> lines) {
        if (name == null) {
            return;
        }
        ArrayList<String> safeLines = lines != null ? new ArrayList<String>(lines) : Collections.emptyList();
        this.runSync(() -> {
            TextDisplay td;
            int i;
            boolean debug = false;
            try {
                if (this.plugin != null) {
                    debug = this.plugin.getConfig().getBoolean("debug-holograms", false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Hologram holo = this.holograms.get(name);
            if (holo == null) {
                if (debug) {
                    MrLibConsoleSayer.MrSay_Warning("[Holograms-TextDisplay] Hologram '" + name + "' not found in map, cannot update (should use createHologram instead)");
                }
                return;
            }
            World world = holo.base.getWorld();
            if (world == null) {
                return;
            }
            int existing = holo.lines.size();
            int target = safeLines.size();
            int added = 0;
            int removed = 0;
            if (debug) {
                MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] update '" + name + "' existing=" + existing + " target=" + target);
                if (safeLines.isEmpty()) {
                    MrLibConsoleSayer.MrSay_Warning("[Holograms-TextDisplay] update with 0 lines for '" + name + "' (will remove extras and leave 0).");
                }
            }
            int min = Math.min(existing, target);
            for (i = 0; i < min; ++i) {
                td = holo.lines.get(i);
                if (td == null || !td.isValid()) {
                    if (!debug) continue;
                    MrLibConsoleSayer.MrSay_Warning("[Holograms-TextDisplay] Line " + i + " is null or invalid for '" + name + "', skipping");
                    continue;
                }
                String raw = safeLines.get(i) == null ? "" : (String)safeLines.get(i);
                String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
                Component text = this.deserialize(colored);
                this.setTextCompat(td, colored, text);
                try {
                    td.setInterpolationDuration(0);
                    td.setInterpolationDelay(0);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (target > existing) {
                for (i = existing; i < target; ++i) {
                    String raw = safeLines.get(i) == null ? "" : (String)safeLines.get(i);
                    String colored = ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
                    Component text = this.deserialize(colored);
                    Location lineLoc = holo.base.clone();
                    lineLoc.setY(holo.base.getY() - (double)i * 0.25);
                    TextDisplay td2 = null;
                    try {
                        td2 = (TextDisplay)world.spawn(lineLoc, TextDisplay.class, display -> {
                            try {
                                display.setBillboard(Display.Billboard.CENTER);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                display.setAlignment(TextDisplay.TextAlignment.CENTER);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                display.setLineWidth(Integer.MAX_VALUE);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                display.setPersistent(true);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.setTextCompat((TextDisplay)display, colored, text);
                            if (this.plugin != null) {
                                try {
                                    display.setMetadata("MrLibCore-Hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        MrLibConsoleSayer.MrSay_Error("[Holograms-TextDisplay] Failed to spawn TextDisplay (update) for '" + name + "' line=" + i + " at " + this.formatLoc(lineLoc) + ": " + t.getMessage());
                    }
                    if (td2 != null) {
                        ++added;
                    }
                    holo.lines.add(td2);
                }
            }
            if (existing > target) {
                for (i = existing - 1; i >= target; --i) {
                    td = holo.lines.remove(i);
                    try {
                        td.remove();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++removed;
                }
            }
            if (debug) {
                MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] update '" + name + "' nowLines=" + holo.lines.size() + " (added=" + added + ", removed=" + removed + ")");
            }
        });
    }

    public boolean hologramExists(String name) {
        return name != null && this.holograms.containsKey(name);
    }

    public String getPerformanceStats() {
        int hologramCount = this.holograms.size();
        int entityCount = this.holograms.values().stream().mapToInt(h -> h.lines.size()).sum();
        return "Holograms=" + hologramCount + ", Entities=" + entityCount;
    }

    public void forceUpdateAll() {
        this.runSync(() -> {
            boolean debug = false;
            try {
                if (this.plugin != null) {
                    debug = this.plugin.getConfig().getBoolean("debug-holograms", false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (Map.Entry<String, Hologram> e : this.holograms.entrySet()) {
                Hologram holo = e.getValue();
                World world = holo.base.getWorld();
                if (world == null) continue;
                for (int i = 0; i < holo.lines.size(); ++i) {
                    TextDisplay td = holo.lines.get(i);
                    Location lineLoc = holo.base.clone();
                    lineLoc.setY(holo.base.getY() - (double)i * 0.25);
                    try {
                        td.teleport(lineLoc);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!debug) continue;
                MrLibConsoleSayer.MrSay_Info("[Holograms-TextDisplay] forceUpdate '" + e.getKey() + "' lines=" + holo.lines.size());
            }
        });
    }

    public void removeAllHolograms() {
        this.removeAllHologramsSync();
    }

    private void removeAllHologramsSync() {
        for (Hologram holo : this.holograms.values()) {
            for (TextDisplay td : holo.lines) {
                try {
                    td.remove();
                }
                catch (Throwable throwable) {}
            }
        }
        this.holograms.clear();
    }

    public void shutdown() {
        this.removeAllHologramsSync();
        instance = null;
    }

    private void runSync(Runnable task) {
        if (task == null) {
            return;
        }
        try {
            if (Bukkit.isPrimaryThread()) {
                task.run();
            } else if (this.plugin != null) {
                Bukkit.getScheduler().runTask(this.plugin, task);
            } else {
                task.run();
                MrLibConsoleSayer.MrSay_Warning("[Holograms-TextDisplay] Running task off-main thread due to missing plugin context.");
            }
        }
        catch (Throwable t) {
            MrLibConsoleSayer.MrSay_Error("[Holograms-TextDisplay] Error executing task: " + t.getMessage());
        }
    }

    private Component deserialize(String legacy) {
        try {
            return LegacyComponentSerializer.legacySection().deserialize(legacy);
        }
        catch (Throwable t) {
            return Component.text((String)legacy);
        }
    }

    private String formatLoc(Location loc) {
        try {
            return (loc.getWorld() != null ? loc.getWorld().getName() : "null") + " " + String.format("(%.2f, %.2f, %.2f)", loc.getX(), loc.getY(), loc.getZ());
        }
        catch (Throwable throwable) {
            return String.valueOf(loc);
        }
    }

    private void setTextCompat(TextDisplay display, String colored, Component comp) {
        if (display == null) {
            return;
        }
        try {
            Method m = display.getClass().getMethod("setText", Component.class);
            m.invoke((Object)display, comp);
            return;
        }
        catch (Throwable m) {
            try {
                Method m2 = display.getClass().getMethod("setText", String.class);
                m2.invoke((Object)display, colored);
                return;
            }
            catch (Throwable throwable) {
                try {
                    display.setCustomName(colored);
                    display.setCustomNameVisible(true);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private static class Hologram {
        private final Location base;
        private final List<TextDisplay> lines;

        private Hologram(Location base, List<TextDisplay> lines) {
            this.base = base;
            this.lines = lines;
        }
    }
}

