/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class MrLibEntityHologram {
    private final String name;
    private final Location location;
    private final Plugin plugin;
    private List<Component> lines;
    private final List<TextDisplay> entities = new ArrayList<TextDisplay>();
    private boolean valid = true;
    private boolean needsUpdate = false;
    private float textScale = 1.0f;
    private int backgroundColor = 0;
    private boolean hasBackground = false;
    private boolean hasShadow = false;
    private byte textOpacity = (byte)-1;
    private boolean seeThrough = false;

    public MrLibEntityHologram(String name, Location location, List<String> lines, Plugin plugin) {
        this(name, location, lines, plugin, 1.0f, 0, false, false);
    }

    public MrLibEntityHologram(String name, Location location, List<String> lines, Plugin plugin, float textScale, int backgroundColor, boolean hasBackground, boolean hasShadow) {
        this.name = name;
        this.location = location;
        this.plugin = plugin;
        this.lines = lines.stream().map(line -> LegacyComponentSerializer.legacyAmpersand().deserialize(line)).collect(Collectors.toList());
        this.textScale = textScale;
        this.backgroundColor = backgroundColor;
        this.hasBackground = hasBackground;
        this.hasShadow = hasShadow;
        this.spawnEntities();
    }

    private void spawnEntities() {
        if (this.location == null || this.location.getWorld() == null) {
            return;
        }
        World world = this.location.getWorld();
        double y = this.location.getY();
        for (Component line : this.lines) {
            TextDisplay entity = (TextDisplay)world.spawn(this.location.clone().add(0.0, y - this.location.getY(), 0.0), TextDisplay.class, e -> {
                e.setBillboard(Display.Billboard.FIXED);
                e.setShadowed(this.hasShadow);
                e.setSeeThrough(this.seeThrough);
                e.setDefaultBackground(this.hasBackground);
                if (this.hasBackground) {
                    e.setBackgroundColor(Color.fromARGB((int)this.backgroundColor));
                }
                e.setTextOpacity(this.textOpacity);
                e.setText(LegacyComponentSerializer.legacySection().serialize(line));
                Transformation t = e.getTransformation();
                e.setTransformation(new Transformation(t.getTranslation(), t.getLeftRotation(), new Vector3f(this.textScale, this.textScale, this.textScale), t.getRightRotation()));
            });
            this.entities.add(entity);
            y -= 0.25;
        }
    }

    public boolean isValid() {
        return this.valid && this.location != null && this.location.getWorld() != null;
    }

    public void remove() {
        for (TextDisplay entity : this.entities) {
            if (entity == null || entity.isDead()) continue;
            entity.remove();
        }
        this.entities.clear();
        this.valid = false;
    }

    public void updateLines(List<String> newLines) {
        if (newLines == null) {
            return;
        }
        this.lines = newLines.stream().map(line -> LegacyComponentSerializer.legacyAmpersand().deserialize(line)).collect(Collectors.toList());
        this.needsUpdate = true;
    }

    public boolean hasNearbyPlayers() {
        if (this.location == null || this.location.getWorld() == null) {
            return false;
        }
        for (Player player : this.location.getWorld().getPlayers()) {
            if (!(player.getLocation().distanceSquared(this.location) <= 4096.0)) continue;
            return true;
        }
        return false;
    }

    public void performUpdate() {
        if (!this.needsUpdate) {
            return;
        }
        if (!this.hasNearbyPlayers()) {
            return;
        }
        this.updateEntitiesSmooth();
        this.needsUpdate = false;
    }

    public void performImmediateUpdate() {
        this.updateEntitiesSmooth();
        this.needsUpdate = false;
    }

    private void updateEntitiesSmooth() {
        for (int i = 0; i < Math.min(this.lines.size(), this.entities.size()); ++i) {
            TextDisplay entity = this.entities.get(i);
            Component newText = this.lines.get(i);
            if (entity == null || entity.isDead()) continue;
            entity.setText(LegacyComponentSerializer.legacySection().serialize(newText));
        }
    }

    public void setTextScale(float scale) {
        this.textScale = scale;
        this.applyDisplaySettings();
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        this.applyDisplaySettings();
    }

    public void setHasBackground(boolean hasBackground) {
        this.hasBackground = hasBackground;
        this.applyDisplaySettings();
    }

    public void setHasShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
        this.applyDisplaySettings();
    }

    public void setTextOpacity(byte opacity) {
        this.textOpacity = opacity;
        this.applyDisplaySettings();
    }

    public void setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        this.applyDisplaySettings();
    }

    private void applyDisplaySettings() {
        for (TextDisplay entity : this.entities) {
            if (entity == null || entity.isDead()) continue;
            entity.setShadowed(this.hasShadow);
            entity.setSeeThrough(this.seeThrough);
            entity.setDefaultBackground(this.hasBackground);
            if (this.hasBackground) {
                entity.setBackgroundColor(Color.fromARGB((int)this.backgroundColor));
            }
            entity.setTextOpacity(this.textOpacity);
            Transformation t = entity.getTransformation();
            entity.setTransformation(new Transformation(t.getTranslation(), t.getLeftRotation(), new Vector3f(this.textScale, this.textScale, this.textScale), t.getRightRotation()));
        }
    }
}

