/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.providers;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MrLibNativeHologramProvider
implements MrLibHologramProvider {
    private final Map<String, List<ArmorStand>> holograms = new ConcurrentHashMap<String, List<ArmorStand>>();
    private final Plugin plugin = Bukkit.getPluginManager().getPlugin("MrLibCore");

    @Override
    public void createHologram(String name, Location location, List<String> lines) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        this.deleteHologram(name);
        ArrayList<ArmorStand> stands = new ArrayList<ArmorStand>();
        double yOffset = 0.0;
        for (int i = lines.size() - 1; i >= 0; --i) {
            String line = lines.get(i);
            if (line == null || line.trim().isEmpty()) {
                yOffset += 0.3;
                continue;
            }
            Location lineLoc = location.clone().add(0.0, yOffset, 0.0);
            ArmorStand as = (ArmorStand)location.getWorld().spawnEntity(lineLoc, EntityType.ARMOR_STAND);
            as.setMarker(true);
            as.setInvisible(true);
            as.setSmall(true);
            as.setGravity(false);
            as.setCustomName(MrLibColors.colorize(line));
            as.setCustomNameVisible(true);
            as.setMetadata("mrlib_hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)name));
            stands.add(as);
            yOffset += 0.3;
        }
        this.holograms.put(name, stands);
    }

    @Override
    public void updateHologram(String name, List<String> lines) {
        List<ArmorStand> stands = this.holograms.get(name);
        if (stands == null || stands.isEmpty()) {
            return;
        }
        if (stands.get(0) != null && !stands.get(0).isDead()) {
            Location baseLoc = stands.get(0).getLocation().clone().subtract(0.0, (double)(stands.size() - 1) * 0.3, 0.0);
            this.deleteHologram(name);
            this.createHologram(name, baseLoc, lines);
        }
    }

    @Override
    public void deleteHologram(String name) {
        List<ArmorStand> stands = this.holograms.remove(name);
        if (stands != null) {
            for (ArmorStand as : stands) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean hologramExists(String name) {
        return this.holograms.containsKey(name);
    }

    @Override
    public String getProviderName() {
        return "MrLibCore";
    }

    public void removeAll() {
        for (String name : new ArrayList<String>(this.holograms.keySet())) {
            this.deleteHologram(name);
        }
    }
}

