/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.messages;

import eu.mrneznamy.mrlibcore.actionbar.MrLibActionBar;
import eu.mrneznamy.mrlibcore.title.MrLibTitle;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibMessage {
    private final JavaPlugin plugin;
    private final MrLibActionBar actionBar;
    private final MrLibTitle title;
    private static final Pattern TAG_PATTERN = Pattern.compile("\\((!?)([^!)]+)(!?)\\)");

    public MrLibMessage(JavaPlugin plugin) {
        this.plugin = plugin;
        this.actionBar = new MrLibActionBar(plugin);
        this.title = new MrLibTitle(plugin);
    }

    public void send(Player player, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        MessageParser parser = new MessageParser(message, player);
        parser.parse();
    }

    public void sendToAll(String message) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.send(player, message);
        }
    }

    public void sendWithPermission(String message, String permission) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            this.send(player, message);
        }
    }

    public String getMessage(String path) {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.plugin.getLogger().info("DEBUG: Looking for messages.yml at: " + messagesFile.getAbsolutePath());
        this.plugin.getLogger().info("DEBUG: File exists: " + messagesFile.exists());
        if (messagesFile.exists()) {
            YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
            String message = messages.getString(path);
            this.plugin.getLogger().info("DEBUG: Message '" + path + "' = '" + message + "'");
            if (message != null) {
                return MrLibColors.colorize(message);
            }
        } else {
            this.plugin.getLogger().info("DEBUG: messages.yml not found at: " + messagesFile.getAbsolutePath());
        }
        return "&cMessage not found: " + path;
    }

    public String getMessage(String path, String defaultValue) {
        YamlConfiguration messages;
        String message;
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (messagesFile.exists() && (message = (messages = YamlConfiguration.loadConfiguration((File)messagesFile)).getString(path)) != null) {
            return MrLibColors.colorize(message);
        }
        return MrLibColors.colorize(defaultValue);
    }

    private class MessageParser {
        private final String input;
        private final Player player;
        private String currentMode = "message";
        private List<MessagePart> parts = new ArrayList<MessagePart>();
        private String pendingHover = null;
        private String pendingClick = null;
        private String pendingSound = null;
        private boolean shouldCloseInventory = false;

        public MessageParser(String input, Player player) {
            this.input = input;
            this.player = player;
        }

        public void parse() {
            MessagePart part;
            String text;
            Matcher matcher = TAG_PATTERN.matcher(this.input);
            int lastEnd = 0;
            while (matcher.find()) {
                if (matcher.start() > lastEnd && !(text = this.input.substring(lastEnd, matcher.start())).isEmpty()) {
                    part = new MessagePart(this.currentMode, text, null);
                    this.applyPendingEffects(part);
                    this.parts.add(part);
                }
                String leftExclamation = matcher.group(1);
                String tag = matcher.group(2);
                String rightExclamation = matcher.group(3);
                this.parseTag(tag);
                lastEnd = matcher.end();
            }
            if (lastEnd < this.input.length() && !(text = this.input.substring(lastEnd)).isEmpty()) {
                part = new MessagePart(this.currentMode, text, null);
                this.applyPendingEffects(part);
                this.parts.add(part);
            }
            this.execute();
        }

        private void parseTag(String tag) {
            if (tag.startsWith("hover:")) {
                this.pendingHover = tag.substring(6);
            } else if (tag.startsWith("click:")) {
                this.pendingClick = tag.substring(6);
            } else if (tag.startsWith("sound:")) {
                this.pendingSound = tag.substring(6);
            } else if (tag.equalsIgnoreCase("close")) {
                this.shouldCloseInventory = true;
            } else {
                this.currentMode = tag.toLowerCase();
            }
        }

        private void applyPendingEffects(MessagePart part) {
            if (this.pendingHover != null) {
                part.hoverText = this.pendingHover;
                this.pendingHover = null;
            }
            if (this.pendingClick != null) {
                part.clickCommand = this.pendingClick;
                this.pendingClick = null;
            }
            if (this.pendingSound != null) {
                part.soundName = this.pendingSound;
                this.pendingSound = null;
            }
        }

        private void execute() {
            ArrayList<TextComponent> chatComponents = new ArrayList<TextComponent>();
            String titleText = null;
            String subtitleText = null;
            String actionBarText = null;
            block14: for (MessagePart part : this.parts) {
                String colored = MrLibColors.colorize(part.text, this.player);
                switch (part.mode) {
                    case "message": {
                        BaseComponent[] components = TextComponent.fromLegacyText((String)colored);
                        if (part.hoverText != null || part.clickCommand != null) {
                            for (BaseComponent comp : components) {
                                if (part.hoverText != null) {
                                    String coloredHover = MrLibColors.colorize(part.hoverText, this.player);
                                    BaseComponent[] hoverComponents = TextComponent.fromLegacyText((String)coloredHover);
                                    comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponents));
                                }
                                if (part.clickCommand == null) continue;
                                comp.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, part.clickCommand));
                            }
                        }
                        for (BaseComponent comp : components) {
                            if (!(comp instanceof TextComponent)) continue;
                            chatComponents.add((TextComponent)comp);
                        }
                        continue block14;
                    }
                    case "title": {
                        titleText = colored;
                        break;
                    }
                    case "subtitle": {
                        subtitleText = colored;
                        break;
                    }
                    case "actionbar": {
                        actionBarText = colored;
                    }
                }
            }
            if (!chatComponents.isEmpty()) {
                BaseComponent[] messageComponents = new BaseComponent[chatComponents.size()];
                for (int i = 0; i < chatComponents.size(); ++i) {
                    messageComponents[i] = (BaseComponent)chatComponents.get(i);
                }
                this.player.spigot().sendMessage(messageComponents);
            }
            if (titleText != null || subtitleText != null) {
                MrLibMessage.this.title.show(this.player, titleText != null ? titleText : "", subtitleText != null ? subtitleText : "", 10, 70, 20);
            }
            if (actionBarText != null) {
                MrLibMessage.this.actionBar.show(this.player, actionBarText);
            }
            for (MessagePart part : this.parts) {
                if (part.soundName == null || part.soundName.isEmpty()) continue;
                try {
                    Sound sound = Sound.valueOf((String)part.soundName.toUpperCase());
                    this.player.playSound(this.player.getLocation(), sound, 1.0f, 1.0f);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (this.shouldCloseInventory) {
                this.player.closeInventory();
            }
        }
    }

    private static class MessagePart {
        String mode;
        String text;
        String hoverText;
        String clickCommand;
        String soundName;

        MessagePart(String mode, String text, String hover) {
            this.mode = mode;
            this.text = text;
            this.hoverText = hover;
        }
    }
}

