/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.utils;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MrLibPluginUpdater {
    private static final String MODRINTH_API = "https://api.modrinth.com/v2";
    private static final Map<String, String> REGISTERED_PLUGINS = new HashMap<String, String>();

    public static void registerPlugin(String pluginName, String modrinthSlug) {
        REGISTERED_PLUGINS.put(pluginName, modrinthSlug);
        MrLibConsoleSayer.MrSay_Info("Registered " + pluginName + " for updates (slug: " + modrinthSlug + ")");
    }

    public static Map<String, String> getRegisteredPlugins() {
        return new HashMap<String, String>(REGISTERED_PLUGINS);
    }

    public static boolean updatePlugin(String pluginName) {
        String slug = REGISTERED_PLUGINS.get(pluginName);
        if (slug == null) {
            MrLibConsoleSayer.MrSay_Warning("Plugin '" + pluginName + "' is not registered for updates");
            return false;
        }
        try {
            String line;
            String versionUrl = "https://api.modrinth.com/v2/project/" + slug + "/version";
            HttpURLConnection conn = (HttpURLConnection)new URL(versionUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "MrLibCore/1.0");
            if (conn.getResponseCode() != 200) {
                MrLibConsoleSayer.MrSay_Error("Failed to fetch version info for " + pluginName);
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            String json = response.toString();
            String downloadUrl = MrLibPluginUpdater.extractDownloadUrl(json);
            if (downloadUrl == null) {
                MrLibConsoleSayer.MrSay_Error("Could not find download URL for " + pluginName);
                return false;
            }
            File pluginsFolder = new File("plugins");
            File newFile = new File(pluginsFolder, pluginName + "-new.jar");
            MrLibConsoleSayer.MrSay_Info("Downloading " + pluginName + "...");
            MrLibPluginUpdater.downloadFile(downloadUrl, newFile);
            File oldFile = MrLibPluginUpdater.findPluginJar(pluginName);
            if (oldFile != null && oldFile.exists()) {
                File oldMarked = new File(pluginsFolder, oldFile.getName() + ".old");
                oldFile.renameTo(oldMarked);
                MrLibConsoleSayer.MrSay_Info("Marked old version for deletion: " + oldFile.getName());
            }
            File finalFile = new File(pluginsFolder, pluginName + ".jar");
            newFile.renameTo(finalFile);
            MrLibConsoleSayer.MrSay_Success("Downloaded " + pluginName + " successfully!");
            return true;
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Failed to update " + pluginName + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static int updateAllPlugins() {
        int updated = 0;
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            String pluginName = plugin.getName();
            if (!REGISTERED_PLUGINS.containsKey(pluginName) || !MrLibPluginUpdater.updatePlugin(pluginName)) continue;
            ++updated;
        }
        MrLibPluginUpdater.deleteOldVersions();
        return updated;
    }

    private static String extractDownloadUrl(String json) {
        try {
            int filesIndex = json.indexOf("\"files\"");
            if (filesIndex == -1) {
                return null;
            }
            int urlIndex = json.indexOf("\"url\"", filesIndex);
            if (urlIndex == -1) {
                return null;
            }
            int startQuote = json.indexOf("\"", urlIndex + 6);
            int endQuote = json.indexOf("\"", startQuote + 1);
            if (startQuote != -1 && endQuote != -1) {
                return json.substring(startQuote + 1, endQuote);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void downloadFile(String urlStr, File destination) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "MrLibCore/1.0");
        try (InputStream in = conn.getInputStream();
             FileOutputStream out = new FileOutputStream(destination);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
    }

    private static File findPluginJar(String pluginName) {
        File pluginsFolder = new File("plugins");
        File[] files = pluginsFolder.listFiles((dir, name) -> name.toLowerCase().startsWith(pluginName.toLowerCase()) && name.endsWith(".jar"));
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    private static void deleteOldVersions() {
        File pluginsFolder = new File("plugins");
        File[] oldFiles = pluginsFolder.listFiles((dir, name) -> name.endsWith(".jar.old"));
        if (oldFiles != null) {
            for (File oldFile : oldFiles) {
                if (!oldFile.delete()) continue;
                MrLibConsoleSayer.MrSay_Info("Deleted old version: " + oldFile.getName());
            }
        }
    }
}

