/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.config;

import eu.mrneznamy.mrlibcore.config.MrLibYamlConfiguration;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibConfigConverter {
    private final JavaPlugin plugin;
    private final Map<String, List<ConversionRule>> conversionRules = new HashMap<String, List<ConversionRule>>();
    private final Map<String, List<String>> fileComments = new HashMap<String, List<String>>();

    public MrLibConfigConverter(JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupConversionRules();
        this.setupComments();
    }

    private boolean shouldSkipConversion(String configName) {
        String pluginName = this.plugin.getName();
        if (pluginName.equals("MrUltimateShop") && (configName.equals("menu.yml") || configName.equals("tracker.yml") || configName.equals("sell-gui.yml") || configName.equals("sell-all-gui.yml") || configName.equals("buy-gui.yml") || configName.startsWith("Shops/"))) {
            return true;
        }
        if (pluginName.equals("MrSellChests") && configName.equals("boosters.yml")) {
            return true;
        }
        if (pluginName.equals("MrUltimateFishing") && (configName.equals("fish.yml") || configName.equals("events.yml") || configName.equals("boosters.yml") || configName.equals("rarity.yml") || configName.equals("tournaments.yml") || configName.equals("delivery.yml") || configName.startsWith("Menus/"))) {
            return true;
        }
        return pluginName.equals("MrUltimateJobs") && (configName.equals("events.yml") || configName.equals("boosters.yml") || configName.equals("tournaments.yml") || configName.equals("data.yml") || configName.startsWith("Jobs/") || configName.startsWith("Menus/"));
    }

    public boolean convertConfig(String configName) {
        if (this.shouldSkipConversion(configName)) {
            return false;
        }
        File oldFile = new File(this.plugin.getDataFolder(), configName);
        if (!oldFile.exists()) {
            return false;
        }
        try {
            List<String> comments;
            File backupFolder = new File(this.plugin.getDataFolder(), "backupFiles");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            File backupFile = new File(backupFolder, configName + ".old-backup." + timestamp);
            Files.copy(oldFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            MrLibConsoleSayer.MrSay_Info("[" + this.plugin.getName() + "] Backed up old " + configName + " to backupFiles/" + backupFile.getName());
            YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldFile);
            MrLibYamlConfiguration newConfig = new MrLibYamlConfiguration();
            List<ConversionRule> rules = this.conversionRules.get(configName);
            if (rules != null) {
                for (ConversionRule rule : rules) {
                    rule.apply(oldConfig, newConfig);
                }
            }
            if ((comments = this.fileComments.get(configName)) != null) {
                for (String comment : comments) {
                    String[] parts = comment.split("\\|", 2);
                    if (parts.length != 2) continue;
                    newConfig.addComment(parts[0], parts[1]);
                }
            }
            newConfig.save(oldFile);
            MrLibConsoleSayer.MrSay_Success("[" + this.plugin.getName() + "] Converted " + configName + " to new format");
            return true;
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("[" + this.plugin.getName() + "] Failed to convert " + configName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean needsConversion(String configName) {
        String versionKey;
        File configFile = new File(this.plugin.getDataFolder(), configName);
        if (!configFile.exists()) {
            return false;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        return !config.contains(versionKey = configName.replace(".yml", "") + "-version");
    }

    private void setupConversionRules() {
        if (this.plugin.getName().equals("MrSellChests")) {
            this.setupMrSellChestsRules();
        } else if (this.plugin.getName().equals("MrUltimateFishing")) {
            this.setupMrUltimateFishingRules();
        } else if (this.plugin.getName().equals("MrUltimateShop")) {
            this.setupMrUltimateShopRules();
        } else if (this.plugin.getName().equals("MrUltimateHoppers")) {
            this.setupMrUltimateHoppersRules();
        } else if (this.plugin.getName().equals("MrUltimateJobs")) {
            this.setupMrUltimateJobsRules();
        } else if (this.plugin.getName().equals("MrVoteTrain")) {
            this.setupMrVoteTrainRules();
        }
    }

    private void setupComments() {
        if (this.plugin.getName().equals("MrSellChests")) {
            this.setupMrSellChestsComments();
        } else if (this.plugin.getName().equals("MrUltimateFishing")) {
            this.setupMrUltimateFishingComments();
        } else if (this.plugin.getName().equals("MrUltimateShop")) {
            this.setupMrUltimateShopComments();
        }
    }

    private void setupMrSellChestsRules() {
        ArrayList<ConversionRule> rules = new ArrayList<ConversionRule>();
        rules.add((oldConfig, newConfig) -> newConfig.set("config-version", 1));
        rules.add((oldConfig, newConfig) -> {
            for (String key : oldConfig.getKeys(true)) {
                if (oldConfig.isConfigurationSection(key)) continue;
                Object value = oldConfig.get(key);
                if (key.startsWith("MrSellChests.")) {
                    newConfig.set(key, value);
                    continue;
                }
                if (key.startsWith("SellChests.") || key.startsWith("SettingsMenu.")) {
                    newConfig.set("MrSellChests." + key, value);
                    continue;
                }
                newConfig.set(key, value);
            }
        });
        rules.add((oldConfig, newConfig) -> {
            if (!newConfig.contains("MrSellChests.Database")) {
                newConfig.set("MrSellChests.Database.Type", "yml");
                newConfig.set("MrSellChests.Database.SQLite.FileName", "sellchests.db");
                newConfig.set("MrSellChests.Database.MySQL.Host", "localhost");
                newConfig.set("MrSellChests.Database.MySQL.Port", 3306);
                newConfig.set("MrSellChests.Database.MySQL.Database", "sellchests");
                newConfig.set("MrSellChests.Database.MySQL.Username", "root");
                newConfig.set("MrSellChests.Database.MySQL.Password", "");
            }
        });
        this.conversionRules.put("config.yml", rules);
        ArrayList<ConversionRule> messagesRules = new ArrayList<ConversionRule>();
        messagesRules.add((oldConfig, newConfig) -> newConfig.set("messages-version", 1));
        messagesRules.add((oldConfig, newConfig) -> {
            for (String key : oldConfig.getKeys(false)) {
                Object value = oldConfig.get(key);
                if (key.equals("prefix")) {
                    newConfig.set("MrSellChests.Prefix", value);
                    continue;
                }
                if (oldConfig.isConfigurationSection(key)) continue;
                Object messageText = value.toString();
                if (!(((String)messageText).contains("(!message!)") || ((String)messageText).contains("(!NOPREFIX!)") || ((String)messageText).contains("(!title!)") || ((String)messageText).contains("(!actionbar!)"))) {
                    messageText = "(!message!)" + (String)messageText;
                }
                newConfig.set("MrSellChests." + key, messageText);
            }
        });
        this.conversionRules.put("messages.yml", messagesRules);
    }

    private void setupMrSellChestsComments() {
        ArrayList<String> comments = new ArrayList<String>();
        comments.add("_HEADER_|# ========================================");
        comments.add("_HEADER_|#     MrSellChests Configuration");
        comments.add("_HEADER_|#     Version: 1.0.4");
        comments.add("_HEADER_|# ========================================");
        comments.add("config-version|# Do not change this! Used for automatic config updates");
        comments.add("MrSellChests.Database|# Database settings for storing sell chest data");
        comments.add("MrSellChests.Database.Type|# Storage type: yml, sqlite, or mysql");
        comments.add("MrSellChests.Database.Host|# MySQL host address");
        comments.add("MrSellChests.Database.Port|# MySQL port (default: 3306)");
        comments.add("MrSellChests.Database.Database|# MySQL database name");
        comments.add("MrSellChests.Database.Username|# MySQL username");
        comments.add("MrSellChests.Database.Password|# MySQL password");
        comments.add("MrSellChests.Holograms|# Hologram settings");
        comments.add("MrSellChests.Holograms.Enabled|# Enable/disable holograms above sell chests");
        comments.add("MrSellChests.Holograms.Provider|# Hologram provider: DecentHolograms, CMI, or MrLibCore");
        comments.add("MrSellChests.Holograms.UpdateInterval|# How often to update holograms (in ticks, 20 ticks = 1 second)");
        comments.add("MrSellChests.SellPrices|# Price provider settings");
        comments.add("MrSellChests.SellPrices.Provider|# Where to get item prices from: FILE, SHOPGUI+, or MrUltimateShop");
        comments.add("MrSellChests.Prefix|# Plugin message prefix");
        this.fileComments.put("config.yml", comments);
    }

    private void setupMrUltimateFishingRules() {
        ArrayList<ConversionRule> configRules = new ArrayList<ConversionRule>();
        configRules.add((oldConfig, newConfig) -> newConfig.set("config-version", 1));
        configRules.add((oldConfig, newConfig) -> {
            for (String key : oldConfig.getKeys(true)) {
                Object newKey;
                if (oldConfig.isConfigurationSection(key)) continue;
                Object value = oldConfig.get(key);
                String rootKey = key.split("\\.")[0];
                if (key.startsWith("MrUltimateFishing.")) {
                    newConfig.set(key, value);
                    continue;
                }
                if (rootKey.equals("fishing")) {
                    newKey = key.replace("fishing.", "MrUltimateFishing.Fishing.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("player-data")) {
                    newKey = key.replace("player-data.", "MrUltimateFishing.Player-Data.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("economy")) {
                    newKey = key.replace("economy.", "MrUltimateFishing.Economy.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("leveling")) {
                    newKey = key.replace("leveling.", "MrUltimateFishing.Leveling.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("debug")) {
                    newKey = key.replace("debug.", "MrUltimateFishing.Debug.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("fallback")) {
                    newKey = key.replace("fallback.", "MrUltimateFishing.Fallback.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("general")) {
                    newKey = key.replace("general.", "MrUltimateFishing.General.");
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("Upgrades")) {
                    newKey = "MrUltimateFishing." + key;
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("CustomDrops")) {
                    newKey = "MrUltimateFishing." + key;
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("Totem")) {
                    newKey = "MrUltimateFishing." + key;
                    newConfig.set((String)newKey, value);
                    continue;
                }
                if (rootKey.equals("CustomEnchants")) {
                    newKey = "MrUltimateFishing." + key;
                    newConfig.set((String)newKey, value);
                    continue;
                }
                newConfig.set("MrUltimateFishing." + key, value);
            }
        });
        configRules.add((oldConfig, newConfig) -> {
            if (!newConfig.contains("MrUltimateFishing.Database")) {
                newConfig.set("MrUltimateFishing.Database.Type", "yml");
                newConfig.set("MrUltimateFishing.Database.SQLite.FileName", "ultimatefishing.db");
                newConfig.set("MrUltimateFishing.Database.MySQL.Host", "localhost");
                newConfig.set("MrUltimateFishing.Database.MySQL.Port", 3306);
                newConfig.set("MrUltimateFishing.Database.MySQL.Database", "minecraft");
                newConfig.set("MrUltimateFishing.Database.MySQL.Username", "root");
                newConfig.set("MrUltimateFishing.Database.MySQL.Password", "");
            }
        });
        this.conversionRules.put("config.yml", configRules);
        ArrayList<ConversionRule> messageRules = new ArrayList<ConversionRule>();
        messageRules.add((oldConfig, newConfig) -> newConfig.set("messages-version", 1));
        messageRules.add((oldConfig, newConfig) -> {
            for (String key : oldConfig.getKeys(true)) {
                boolean isGuiProperty;
                String newKey;
                if (oldConfig.isConfigurationSection(key)) continue;
                Object value = oldConfig.get(key);
                String rootKey = key.split("\\.")[0];
                if (key.startsWith("MrUltimateFishing.")) {
                    newConfig.set(key, value);
                    continue;
                }
                if (key.equals("prefix")) {
                    newConfig.set("MrUltimateFishing.Prefix", value);
                    continue;
                }
                if (rootKey.equals("Items")) {
                    newKey = "MrUltimateFishing." + key;
                    if (value instanceof String) {
                        String strValue = (String)value;
                        strValue = strValue.replace("{prefix}", "");
                        newConfig.set(newKey, strValue);
                        continue;
                    }
                    newConfig.set(newKey, value);
                    continue;
                }
                if (rootKey.equals("menu-keys")) {
                    newKey = "MrUltimateFishing." + key;
                    if (value instanceof String) {
                        String strValue = (String)value;
                        strValue = strValue.replace("{prefix}", "");
                        newConfig.set(newKey, strValue);
                        continue;
                    }
                    newConfig.set(newKey, value);
                    continue;
                }
                Object messageText = value.toString();
                boolean isActionbar = ((String)(messageText = ((String)messageText).replace("{prefix}", ""))).contains("(!actionbar!)") || key.contains("actionbar");
                boolean isTitle = ((String)messageText).contains("(!title!)");
                boolean isSubtitle = ((String)messageText).contains("(!subtitle!)");
                boolean hasNoPrefix = ((String)messageText).contains("(!NOPREFIX!)");
                boolean isActionbarKey = key.toLowerCase().contains("actionbar");
                boolean bl = isGuiProperty = key.toLowerCase().contains("name") || key.toLowerCase().contains("active") || key.toLowerCase().contains("inactive") || key.toLowerCase().contains("display-name") || key.toLowerCase().contains("material") || key.toLowerCase().contains("custom-model-data") || key.toLowerCase().contains("glowing") || key.toLowerCase().contains("description") || key.toLowerCase().contains("lore");
                if (isGuiProperty || isActionbarKey) {
                    messageText = ((String)messageText).replaceAll("\\(![^!]*!\\)", "");
                } else if (!(((String)messageText).contains("(!message!)") || isActionbar || isTitle || isSubtitle || hasNoPrefix)) {
                    messageText = "(!message!)" + (String)messageText;
                }
                newConfig.set("MrUltimateFishing." + key, messageText);
            }
        });
        this.conversionRules.put("messages.yml", messageRules);
    }

    private void setupMrUltimateFishingComments() {
        ArrayList<String> comments = new ArrayList<String>();
        comments.add("_HEADER_|# ========================================");
        comments.add("_HEADER_|#     MrUltimateFishing Configuration");
        comments.add("_HEADER_|#     Version: 1.0.8");
        comments.add("_HEADER_|# ========================================");
        comments.add("config-version|# Do not change this! Used for automatic config updates");
        comments.add("MrUltimateFishing|# Main plugin configuration");
        comments.add("MrUltimateFishing.Database|# Database configuration");
        comments.add("MrUltimateFishing.Database.Type|# Storage type: yml, sqlite, or mysql");
        comments.add("MrUltimateFishing.Database.SQLite|# SQLite settings");
        comments.add("MrUltimateFishing.Database.SQLite.FileName|# SQLite database file name");
        comments.add("MrUltimateFishing.Database.MySQL|# MySQL settings");
        comments.add("MrUltimateFishing.Database.MySQL.Host|# MySQL host address");
        comments.add("MrUltimateFishing.Database.MySQL.Port|# MySQL port (default: 3306)");
        comments.add("MrUltimateFishing.Database.MySQL.Database|# MySQL database name");
        comments.add("MrUltimateFishing.Database.MySQL.Username|# MySQL username");
        comments.add("MrUltimateFishing.Database.MySQL.Password|# MySQL password");
        comments.add("MrUltimateFishing.HologramProvider|# Hologram provider: MrLibCore, DecentHolograms, CMI, or CMIHolograms");
        comments.add("MrUltimateFishing.General|# General settings");
        comments.add("MrUltimateFishing.General.Prefix|# Plugin message prefix");
        comments.add("MrUltimateFishing.Fishing|# Fishing settings");
        comments.add("MrUltimateFishing.Fishing.Enabled|# Enable/disable fishing system");
        comments.add("MrUltimateFishing.Fishing.Replace-Vanilla|# Replace vanilla fishing with custom fish");
        comments.add("MrUltimateFishing.Leveling|# Leveling system");
        comments.add("MrUltimateFishing.Leveling.Enabled|# Enable/disable leveling system");
        comments.add("MrUltimateFishing.Leveling.Max-Level|# Maximum level players can reach");
        comments.add("MrUltimateFishing.Leveling.Base-XP|# Base XP required for level 1");
        comments.add("MrUltimateFishing.Leveling.XP-Multiplier|# XP multiplier per level");
        comments.add("MrUltimateFishing.Economy|# Economy settings");
        comments.add("MrUltimateFishing.Economy.Fish-Scale|# Fish scales currency");
        comments.add("MrUltimateFishing.Economy.Fish-Scale.Enabled|# Enable fish scales");
        comments.add("MrUltimateFishing.Economy.Fish-Scale.Starting-Amount|# Starting amount of fish scales");
        comments.add("MrUltimateFishing.Economy.Fish-Scale.Max-Amount|# Maximum fish scales a player can have");
        comments.add("MrUltimateFishing.Player-Data|# Player data settings");
        comments.add("MrUltimateFishing.Player-Data.Track-First-Catch|# Track first catches");
        comments.add("MrUltimateFishing.Player-Data.Auto-Save|# Auto-save player data");
        comments.add("MrUltimateFishing.Player-Data.Save-Interval|# Auto-save interval in minutes");
        comments.add("MrUltimateFishing.Totem|# Fishing totem settings");
        comments.add("MrUltimateFishing.Totem.Enabled|# Enable fishing totems");
        comments.add("MrUltimateFishing.Totem.Y-Level|# Height of totem hologram above block");
        comments.add("MrUltimateFishing.Totem.Radius|# Totem effect radius");
        comments.add("MrUltimateFishing.Totem.Duration|# Totem duration in seconds");
        comments.add("MrUltimateFishing.Totem.Cooldown|# Totem cooldown in seconds");
        comments.add("MrUltimateFishing.Debug|# Debug settings");
        comments.add("MrUltimateFishing.Debug.Enabled|# Enable debug mode");
        this.fileComments.put("config.yml", comments);
        ArrayList<String> messageComments = new ArrayList<String>();
        messageComments.add("_HEADER_|# ========================================");
        messageComments.add("_HEADER_|#     MrUltimateFishing Messages");
        messageComments.add("_HEADER_|#     Version: 1.0.8");
        messageComments.add("_HEADER_|#     ");
        messageComments.add("_HEADER_|#     All messages support tags:");
        messageComments.add("_HEADER_|#     (!message!) (!title!) (!subtitle!) (!actionbar!)");
        messageComments.add("_HEADER_|#     (!sound:SOUND!) (!close!) (!NOPREFIX!)");
        messageComments.add("_HEADER_|# ========================================");
        messageComments.add("messages-version|# Do not change this! Used for automatic config updates");
        messageComments.add("MrUltimateFishing|# Main plugin messages");
        messageComments.add("MrUltimateFishing.Prefix|# Plugin prefix for messages");
        this.fileComments.put("messages.yml", messageComments);
    }

    private void setupMrUltimateShopRules() {
        ArrayList<ConversionRule> rules = new ArrayList<ConversionRule>();
        rules.add((oldConfig, newConfig) -> newConfig.set("config-version", 1));
        rules.add((oldConfig, newConfig) -> {
            for (String key : oldConfig.getKeys(true)) {
                if (oldConfig.isConfigurationSection(key)) continue;
                Object value = oldConfig.get(key);
                if (key.startsWith("MrUltimateShop.")) {
                    newConfig.set(key, value);
                    continue;
                }
                if (key.startsWith("Database.") || key.startsWith("economy.") || key.startsWith("Logging.") || key.startsWith("World-Settings.") || key.startsWith("Features.") || key.startsWith("shop.") || key.startsWith("messages.") || key.startsWith("ChestShops.")) {
                    newConfig.set("MrUltimateShop." + key, value);
                    continue;
                }
                newConfig.set(key, value);
            }
        });
        rules.add((oldConfig, newConfig) -> {
            if (!newConfig.contains("MrUltimateShop.Database")) {
                newConfig.set("MrUltimateShop.Database.Type", "yml");
                newConfig.set("MrUltimateShop.Database.SQLite.FileName", "ultimateshop.db");
                newConfig.set("MrUltimateShop.Database.MySQL.Host", "localhost");
                newConfig.set("MrUltimateShop.Database.MySQL.Port", 3306);
                newConfig.set("MrUltimateShop.Database.MySQL.Database", "ultimateshop");
                newConfig.set("MrUltimateShop.Database.MySQL.Username", "root");
                newConfig.set("MrUltimateShop.Database.MySQL.Password", "");
            }
        });
        rules.add((oldConfig, newConfig) -> {
            if (newConfig.contains("MrUltimateShop.economy.use-vault")) {
                boolean useVault = newConfig.getBoolean("MrUltimateShop.economy.use-vault", true);
                String symbol = newConfig.getString("MrUltimateShop.economy.currency-symbol", "$");
                String format = newConfig.getString("MrUltimateShop.economy.number-format", "#,##0.00");
                newConfig.set("MrUltimateShop.economy.use-vault", null);
                newConfig.set("MrUltimateShop.economy.currency-symbol", null);
                newConfig.set("MrUltimateShop.economy.number-format", null);
                newConfig.set("MrUltimateShop.Economy.Vault.Enabled", useVault);
                newConfig.set("MrUltimateShop.Economy.Vault.Symbol", symbol);
                newConfig.set("MrUltimateShop.Economy.Vault.Number-Format", format);
                newConfig.set("MrUltimateShop.Economy.MrVoteTrain.Enabled", false);
                newConfig.set("MrUltimateShop.Economy.MrVoteTrain.Symbol", " VB");
                newConfig.set("MrUltimateShop.Economy.MrVoteTrain.Number-Format", "#,##0");
            }
        });
        this.conversionRules.put("config.yml", rules);
        ArrayList<ConversionRule> messagesRules = new ArrayList<ConversionRule>();
        messagesRules.add((oldConfig, newConfig) -> newConfig.set("messages-version", 1));
        messagesRules.add((oldConfig, newConfig) -> {
            for (String key : oldConfig.getKeys(true)) {
                if (oldConfig.isConfigurationSection(key)) continue;
                Object value = oldConfig.get(key);
                if (key.startsWith("MrUltimateShop.")) {
                    newConfig.set(key, value);
                    continue;
                }
                if (key.startsWith("general.") || key.startsWith("shop.") || key.startsWith("sell.") || key.startsWith("sell-gui.") || key.startsWith("buysell.") || key.startsWith("errors.") || key.startsWith("commands.") || key.startsWith("Chest-Shop.")) {
                    String messageKey = key.substring(key.indexOf(".") + 1);
                    Object messageText = value.toString();
                    if (!((String)messageText).contains("(!message!)") && !((String)messageText).contains("(!NOPREFIX!)")) {
                        messageText = "(!message!)" + (String)messageText;
                    }
                    newConfig.set("MrUltimateShop." + messageKey.replace(".", "-"), messageText);
                    continue;
                }
                newConfig.set(key, value);
            }
        });
        this.conversionRules.put("messages.yml", messagesRules);
    }

    private void setupMrUltimateShopComments() {
    }

    private void setupMrUltimateHoppersRules() {
    }

    private void setupMrUltimateJobsRules() {
        ArrayList<ConversionRule> messageRules = new ArrayList<ConversionRule>();
        messageRules.add((oldConfig, newConfig) -> newConfig.set("messages-version", 1));
        messageRules.add((oldConfig, newConfig) -> {
            MrLibConsoleSayer.MrSay_Info("Converting messages.yml for MrUltimateJobs...");
            for (String key : oldConfig.getKeys(true)) {
                boolean isGuiKey;
                Object messageText;
                if (!oldConfig.isString(key) || (messageText = oldConfig.getString(key)) == null || ((String)messageText).trim().isEmpty()) continue;
                messageText = ((String)messageText).replace("{prefix}", "");
                boolean hasNoPrefix = ((String)messageText).contains("(!NOPREFIX!)");
                boolean hasMessageTag = ((String)messageText).contains("(!message!)");
                boolean hasTitleTag = ((String)messageText).contains("(!title!)");
                boolean hasActionbarTag = ((String)messageText).contains("(!actionbar!)");
                boolean hasSubtitleTag = ((String)messageText).contains("(!subtitle!)");
                boolean isActionbarKey = key.toLowerCase().contains("actionbar");
                boolean bl = isGuiKey = key.toLowerCase().contains("name") || key.toLowerCase().contains("active") || key.toLowerCase().contains("inactive") || key.toLowerCase().contains("display-name") || key.toLowerCase().contains("material") || key.toLowerCase().contains("custom-model-data") || key.toLowerCase().contains("glowing") || key.toLowerCase().contains("description") || key.toLowerCase().contains("lore");
                if (hasTitleTag || hasActionbarTag || hasSubtitleTag || isActionbarKey || isGuiKey) {
                    messageText = ((String)messageText).replaceAll("\\(![^!]*!\\)", "");
                } else if (!(hasMessageTag || hasNoPrefix || hasTitleTag || hasActionbarTag || hasSubtitleTag)) {
                    messageText = "(!message!)" + (String)messageText;
                }
                newConfig.set("MrUltimateJobs." + key, messageText);
            }
        });
        messageRules.add((oldConfig, newConfig) -> {
            ArrayList<String> messageComments = new ArrayList<String>();
            messageComments.add("_HEADER_|# MrUltimateJobs Messages Configuration");
            messageComments.add("_HEADER_|# Use & for color codes");
            messageComments.add("_HEADER_|# Available placeholders: [PlayerName], [Level], [XP], [Money], [Job], [EventName], [TournamentName]");
            messageComments.add("_HEADER_|# ========================================");
            messageComments.add("_HEADER_|# Available tags:");
            messageComments.add("_HEADER_|#     (!message!) (!title!) (!subtitle!) (!actionbar!)");
            messageComments.add("_HEADER_|#     (!sound:SOUND!) (!close!) (!NOPREFIX!)");
            messageComments.add("_HEADER_|# ========================================");
            messageComments.add("messages-version|# Do not change this! Used for automatic config updates");
            newConfig.setComments("", messageComments);
        });
        this.conversionRules.put("messages.yml", messageRules);
    }

    private void setupMrVoteTrainRules() {
    }

    @FunctionalInterface
    public static interface ConversionRule {
        public void apply(YamlConfiguration var1, MrLibYamlConfiguration var2);
    }
}

