/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.config;

import eu.mrneznamy.mrlibcore.config.MrLibConfigConverter;
import eu.mrneznamy.mrlibcore.config.MrLibConfigMerger;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibConfigDownloader {
    private static final String BASE_URL = "https://pack.mrneznamy.eu/configs/";
    private static final int TIMEOUT = 10000;
    private final JavaPlugin plugin;
    private final String pluginName;

    public MrLibConfigDownloader(JavaPlugin plugin) {
        this.plugin = plugin;
        this.pluginName = plugin.getName();
    }

    public void downloadConfigs() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.convertOldConfigs();
                Map<String, Integer> configVersions = this.getConfigVersions();
                if (configVersions.isEmpty()) {
                    MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] No remote configurations found, using defaults");
                    this.createDefaultConfigs();
                    return;
                }
                if (this.pluginName.equals("MrUltimateShop")) {
                    this.downloadMrUltimateShopConfigs(configVersions);
                } else if (this.pluginName.equals("MrUltimateFishing")) {
                    this.downloadMrUltimateFishingConfigs(configVersions);
                } else if (this.pluginName.equals("MrUltimateJobs")) {
                    this.downloadMrUltimateJobsConfigs(configVersions);
                } else if (this.pluginName.equals("MrSellChests")) {
                    this.downloadMrSellChestsConfigs(configVersions);
                } else {
                    for (Map.Entry<String, Integer> entry : configVersions.entrySet()) {
                        String configName = entry.getKey();
                        int remoteVersion = entry.getValue();
                        this.downloadConfig(configName, remoteVersion);
                    }
                }
                MrLibConsoleSayer.MrSay_Success("[" + this.pluginName + "] Configuration files loaded successfully");
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] Failed to download configs: " + e.getMessage());
                MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] Using local configuration files");
                this.createDefaultConfigs();
            }
        });
    }

    private void downloadMrUltimateShopConfigs(Map<String, Integer> configVersions) {
        File shopsMarker;
        for (Map.Entry<String, Integer> entry : configVersions.entrySet()) {
            File shopsMarker2;
            String configName = entry.getKey();
            int remoteVersion = entry.getValue();
            if (configName.equals("config.yml") || configName.equals("messages.yml")) {
                this.downloadConfig(configName, remoteVersion);
                continue;
            }
            if (configName.equals("tracker.yml") || configName.equals("sell-gui.yml") || configName.equals("sell-all-gui.yml") || configName.equals("menu.yml") || configName.equals("buy-gui.yml")) {
                File configFile = new File(this.plugin.getDataFolder(), configName);
                if (!configFile.exists()) {
                    this.downloadConfig(configName, remoteVersion);
                    continue;
                }
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " already exists, skipping download");
                continue;
            }
            if (!configName.startsWith("Shops/") || (shopsMarker2 = new File(this.plugin.getDataFolder(), ".shops-downloaded")).exists()) continue;
            this.downloadConfigWithoutMerge(configName, remoteVersion);
        }
        if (configVersions.keySet().stream().anyMatch(name -> name.startsWith("Shops/")) && !(shopsMarker = new File(this.plugin.getDataFolder(), ".shops-downloaded")).exists()) {
            try {
                shopsMarker.createNewFile();
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] Shops downloaded - will not download again (even if missing)");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void downloadMrUltimateFishingConfigs(Map<String, Integer> configVersions) {
        for (Map.Entry<String, Integer> entry : configVersions.entrySet()) {
            File configFile;
            String configName = entry.getKey();
            int remoteVersion = entry.getValue();
            if (configName.equals("config.yml") || configName.equals("messages.yml")) {
                this.downloadConfig(configName, remoteVersion);
                continue;
            }
            if (configName.equals("fish.yml") || configName.equals("events.yml") || configName.equals("boosters.yml") || configName.equals("rarity.yml") || configName.equals("tournaments.yml")) {
                configFile = new File(this.plugin.getDataFolder(), configName);
                if (!configFile.exists()) {
                    this.downloadConfig(configName, remoteVersion);
                    continue;
                }
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " already exists, skipping download");
                continue;
            }
            if (!configName.startsWith("Menus/")) continue;
            configFile = new File(this.plugin.getDataFolder(), configName);
            if (!configFile.exists()) {
                this.downloadConfig(configName, remoteVersion);
                continue;
            }
            MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " already exists, skipping download");
        }
    }

    private void downloadMrUltimateJobsConfigs(Map<String, Integer> configVersions) {
        File jobsMarker;
        for (Map.Entry<String, Integer> entry : configVersions.entrySet()) {
            File jobsMarker2;
            File configFile;
            String configName = entry.getKey();
            int remoteVersion = entry.getValue();
            if (configName.equals("config.yml") || configName.equals("messages.yml")) {
                this.downloadConfig(configName, remoteVersion);
                continue;
            }
            if (configName.equals("boosters.yml") || configName.equals("events.yml") || configName.equals("tournaments.yml") || configName.equals("data.yml")) {
                configFile = new File(this.plugin.getDataFolder(), configName);
                if (!configFile.exists()) {
                    this.downloadConfigWithoutMerge(configName, remoteVersion);
                    continue;
                }
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " already exists, skipping download");
                continue;
            }
            if (configName.startsWith("Menus/")) {
                configFile = new File(this.plugin.getDataFolder(), configName);
                if (!configFile.exists()) {
                    this.downloadConfigWithoutMerge(configName, remoteVersion);
                    continue;
                }
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " already exists, skipping download");
                continue;
            }
            if (!configName.startsWith("Jobs/") || (jobsMarker2 = new File(this.plugin.getDataFolder(), ".jobs-downloaded")).exists()) continue;
            this.downloadConfigWithoutMerge(configName, remoteVersion);
        }
        if (configVersions.keySet().stream().anyMatch(name -> name.startsWith("Jobs/")) && !(jobsMarker = new File(this.plugin.getDataFolder(), ".jobs-downloaded")).exists()) {
            try {
                jobsMarker.createNewFile();
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] Jobs downloaded - will not download again (even if missing)");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void downloadMrSellChestsConfigs(Map<String, Integer> configVersions) {
        for (Map.Entry<String, Integer> entry : configVersions.entrySet()) {
            String configName = entry.getKey();
            int remoteVersion = entry.getValue();
            if (configName.equals("config.yml") || configName.equals("messages.yml")) {
                this.downloadConfig(configName, remoteVersion);
                continue;
            }
            if (!configName.equals("sell-prices.yml") && !configName.equals("boosters.yml")) continue;
            File configFile = new File(this.plugin.getDataFolder(), configName);
            if (!configFile.exists()) {
                this.downloadConfigWithoutMerge(configName, remoteVersion);
                continue;
            }
            MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " already exists, skipping download");
        }
    }

    private void convertOldConfigs() {
        try {
            MrLibConfigConverter converter = new MrLibConfigConverter(this.plugin);
            String[] configsToConvert = this.pluginName.equals("MrUltimateFishing") ? new String[]{"config.yml", "messages.yml", "fish.yml", "events.yml", "boosters.yml", "rarity.yml", "tournaments.yml"} : (this.pluginName.equals("MrUltimateJobs") ? new String[]{"config.yml", "messages.yml", "boosters.yml", "events.yml", "tournaments.yml", "data.yml"} : new String[]{"config.yml", "messages.yml", "menu.yml", "boosters.yml"});
            for (String configName : configsToConvert) {
                if (!converter.needsConversion(configName)) continue;
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] Converting old " + configName + " to new format...");
                converter.convertConfig(configName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Integer> getConfigVersions() {
        HashMap<String, Integer> versions = new HashMap<String, Integer>();
        try {
            URL url = new URL(BASE_URL + this.pluginName.toLowerCase() + "/versions.json");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", this.pluginName + "/" + this.plugin.getDescription().getVersion());
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                String json = response.toString();
                this.parseVersionsJson(json, versions);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versions;
    }

    private void parseVersionsJson(String json, Map<String, Integer> versions) {
        try {
            String[] entries;
            json = json.trim();
            if (json.startsWith("{")) {
                json = json.substring(1);
            }
            if (json.endsWith("}")) {
                json = json.substring(0, json.length() - 1);
            }
            for (String entry : entries = json.split(",")) {
                String[] parts = entry.split(":");
                if (parts.length != 2) continue;
                String key = parts[0].trim().replace("\"", "");
                int version = Integer.parseInt(parts[1].trim());
                versions.put(key, version);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void downloadConfig(String configName, int remoteVersion) {
        block22: {
            try {
                File configFile = new File(this.plugin.getDataFolder(), configName);
                File tempFile = new File(this.plugin.getDataFolder(), configName + ".remote-temp");
                if (configName.equals("boosters.yml")) {
                    return;
                }
                boolean isMessagesFile = configName.equals("messages.yml");
                int localVersion = 0;
                if (configFile.exists()) {
                    YamlConfiguration localConfig = YamlConfiguration.loadConfiguration((File)configFile);
                    String versionKey = configName.replace(".yml", "") + "-version";
                    localVersion = localConfig.getInt(versionKey, 0);
                }
                if (remoteVersion > localVersion || !configFile.exists()) {
                    URL url = new URL(BASE_URL + this.pluginName.toLowerCase() + "/" + configName);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-Agent", this.pluginName + "/" + this.plugin.getDescription().getVersion());
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 200) {
                        if (!this.plugin.getDataFolder().exists()) {
                            this.plugin.getDataFolder().mkdirs();
                        }
                        try (InputStream inputStream = connection.getInputStream();
                             FileOutputStream outputStream = new FileOutputStream(tempFile);){
                            int bytesRead;
                            byte[] buffer = new byte[4096];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, bytesRead);
                            }
                        }
                        MrLibConfigMerger merger = new MrLibConfigMerger(this.plugin);
                        if (isMessagesFile) {
                            merger.mergeMessagesOnly(configFile, tempFile, configName);
                            MrLibConsoleSayer.MrSay_Success("[" + this.pluginName + "] Added new messages to " + configName + " (v" + remoteVersion + ", user customizations preserved)");
                        } else {
                            merger.smartMerge(configFile, tempFile, configName);
                            MrLibConsoleSayer.MrSay_Success("[" + this.pluginName + "] Updated " + configName + " to v" + remoteVersion + " (preserved user data)");
                        }
                        tempFile.delete();
                        break block22;
                    }
                    MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] Failed to download " + configName + " (HTTP " + responseCode + ")");
                    break block22;
                }
                MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] " + configName + " is up to date (v" + localVersion + ")");
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] Error downloading " + configName + ": " + e.getMessage());
            }
        }
    }

    private void downloadConfigWithoutMerge(String configName, int remoteVersion) {
        block17: {
            try {
                File configFile = new File(this.plugin.getDataFolder(), configName);
                File tempFile = new File(this.plugin.getDataFolder(), configName + ".remote-temp");
                configFile.getParentFile().mkdirs();
                URL url = new URL(BASE_URL + this.pluginName.toLowerCase() + "/" + configName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", this.pluginName + "/" + this.plugin.getDescription().getVersion());
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    try (InputStream inputStream = connection.getInputStream();
                         FileOutputStream outputStream = new FileOutputStream(tempFile);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                    }
                    if (tempFile.exists()) {
                        tempFile.renameTo(configFile);
                        MrLibConsoleSayer.MrSay_Success("[" + this.pluginName + "] Downloaded " + configName + " (v" + remoteVersion + ")");
                    }
                    break block17;
                }
                MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] Failed to download " + configName + " (HTTP " + responseCode + ")");
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Warning("[" + this.pluginName + "] Error downloading " + configName + ": " + e.getMessage());
            }
        }
    }

    private void createDefaultConfigs() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                File messagesFile;
                File configFile = new File(this.plugin.getDataFolder(), "config.yml");
                if (!configFile.exists()) {
                    this.plugin.saveDefaultConfig();
                    MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] Created default config.yml");
                }
                if (!(messagesFile = new File(this.plugin.getDataFolder(), "messages.yml")).exists() && this.plugin.getResource("messages.yml") != null) {
                    this.plugin.saveResource("messages.yml", false);
                    MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] Created default messages.yml");
                }
                for (String fileName : new String[]{"menu.yml", "shops.yml", "items.yml", "boosters.yml"}) {
                    File file = new File(this.plugin.getDataFolder(), fileName);
                    if (file.exists() || this.plugin.getResource(fileName) == null) continue;
                    this.plugin.saveResource(fileName, false);
                    MrLibConsoleSayer.MrSay_Info("[" + this.pluginName + "] Created default " + fileName);
                }
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error("[" + this.pluginName + "] Failed to create default configs: " + e.getMessage());
            }
        });
    }

    public void forceDownload() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Map<String, Integer> configVersions = this.getConfigVersions();
                for (Map.Entry<String, Integer> entry : configVersions.entrySet()) {
                    String configName = entry.getKey();
                    int remoteVersion = entry.getValue();
                    File configFile = new File(this.plugin.getDataFolder(), configName);
                    if (configFile.exists()) {
                        configFile.delete();
                    }
                    this.downloadConfig(configName, remoteVersion);
                }
                MrLibConsoleSayer.MrSay_Success("[" + this.pluginName + "] Force downloaded all configuration files");
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error("[" + this.pluginName + "] Force download failed: " + e.getMessage());
            }
        });
    }
}

