/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.database;

import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import eu.mrneznamy.mrlibcore.database.MrLibMySQL;
import eu.mrneznamy.mrlibcore.database.MrLibSQLite;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibDatabaseManager {
    private static final Map<String, MrLibDatabase> databases = new HashMap<String, MrLibDatabase>();

    public static MrLibDatabase registerMySQL(String pluginName, String host, int port, String database, String username, String password) {
        MrLibMySQL mysql = new MrLibMySQL(host, port, database, username, password);
        databases.put(pluginName.toLowerCase(), mysql);
        if (mysql.connect()) {
            return mysql;
        }
        return null;
    }

    public static MrLibDatabase registerSQLite(JavaPlugin plugin, String fileName) {
        File dbFile = new File(plugin.getDataFolder(), fileName);
        MrLibSQLite sqlite = new MrLibSQLite(dbFile);
        databases.put(plugin.getName().toLowerCase(), sqlite);
        if (sqlite.connect()) {
            return sqlite;
        }
        return null;
    }

    public static MrLibDatabase getDatabase(String pluginName) {
        return databases.get(pluginName.toLowerCase());
    }

    public static void unregister(String pluginName) {
        MrLibDatabase db = databases.remove(pluginName.toLowerCase());
        if (db != null) {
            db.disconnect();
        }
    }

    public static void disconnectAll() {
        databases.values().forEach(MrLibDatabase::disconnect);
        databases.clear();
    }
}

