/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.database;

import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;

public class MrLibMySQL
implements MrLibDatabase {
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private Connection connection;

    public MrLibMySQL(String host, int port, String database, String username, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return true;
            }
            String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?autoReconnect=true&useSSL=false";
            this.connection = DriverManager.getConnection(url, this.username, this.password);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void disconnect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.connection;
    }

    @Override
    public int executeUpdate(String sql, Object ... params) {
        int n;
        block8: {
            PreparedStatement stmt = this.prepareStatement(sql, params);
            try {
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
            stmt.close();
        }
        return n;
    }

    @Override
    public void executeQuery(String sql, Consumer<ResultSet> callback, Object ... params) {
        try (PreparedStatement stmt = this.prepareStatement(sql, params);
             ResultSet rs = stmt.executeQuery();){
            callback.accept(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResultSet executeQuerySync(String sql, Object ... params) {
        try {
            PreparedStatement stmt = this.prepareStatement(sql, params);
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void createTable(String tableName, String columns) {
        String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (" + columns + ")";
        this.executeUpdate(sql, new Object[0]);
    }

    @Override
    public boolean tableExists(String tableName) {
        try {
            DatabaseMetaData meta = this.getConnection().getMetaData();
            ResultSet rs = meta.getTables(null, null, tableName, new String[]{"TABLE"});
            return rs.next();
        }
        catch (SQLException e) {
            return false;
        }
    }

    private PreparedStatement prepareStatement(String sql, Object ... params) throws SQLException {
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
        return stmt;
    }
}

