/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.economy;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class MrLibVaultManager {
    private static MrLibVaultManager instance;
    private Economy economy;
    private boolean enabled = false;

    private MrLibVaultManager() {
        this.setupEconomy();
    }

    public static MrLibVaultManager getInstance() {
        if (instance == null) {
            instance = new MrLibVaultManager();
        }
        return instance;
    }

    private void setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            MrLibConsoleSayer.MrSay_Warning("Vault not found! Economy features will be disabled.");
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            MrLibConsoleSayer.MrSay_Warning("No economy plugin found! Economy features will be disabled.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.enabled = true;
        MrLibConsoleSayer.MrSay_Success("Vault economy integration enabled!");
    }

    public boolean isEnabled() {
        return this.enabled && this.economy != null;
    }

    public double getBalance(Player player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        try {
            return this.economy.getBalance((OfflinePlayer)player);
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Error getting balance for player " + player.getName() + ": " + e.getMessage());
            return 0.0;
        }
    }

    public boolean hasEnough(Player player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            return this.economy.has((OfflinePlayer)player, amount);
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Error checking balance for player " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    public boolean deposit(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            return this.economy.depositPlayer(player, amount).transactionSuccess();
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Error depositing money to player " + player.getName() + ": " + e.getMessage());
            if (e.getMessage().contains("zip file closed")) {
                MrLibConsoleSayer.MrSay_Error("Database connection issue detected. Try restarting the server.");
            }
            return false;
        }
    }

    public boolean withdraw(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            return this.economy.withdrawPlayer(player, amount).transactionSuccess();
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error("Error withdrawing money from player " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    public String format(double amount) {
        if (!this.isEnabled()) {
            return String.format("%.2f", amount);
        }
        try {
            return this.economy.format(amount);
        }
        catch (Exception e) {
            return String.format("%.2f", amount);
        }
    }

    public String getCurrencySymbol() {
        if (!this.isEnabled()) {
            return "$";
        }
        try {
            String formatted = this.economy.format(1.0);
            return formatted.replaceAll("[0-9.,\\s]", "").trim();
        }
        catch (Exception e) {
            return "$";
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

