/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.gui;

import eu.mrneznamy.mrlibcore.gui.MrLibGUI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class MrLibGUIManager
implements Listener {
    private static final Map<UUID, MrLibGUI> openGUIs = new HashMap<UUID, MrLibGUI>();

    public static void registerGUI(Player player, MrLibGUI gui) {
        openGUIs.put(player.getUniqueId(), gui);
    }

    public static void unregisterGUI(Player player) {
        openGUIs.remove(player.getUniqueId());
    }

    public static MrLibGUI getGUI(Player player) {
        return openGUIs.get(player.getUniqueId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        MrLibGUI gui = openGUIs.get(player.getUniqueId());
        if (gui != null && event.getInventory().equals((Object)gui.getInventory())) {
            gui.handleClick(event);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        MrLibGUI gui = openGUIs.get(player.getUniqueId());
        if (gui != null && event.getInventory().equals((Object)gui.getInventory())) {
            gui.handleClose(event);
            MrLibGUIManager.unregisterGUI(player);
        }
    }
}

