/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.gui;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MrLibItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;

    public MrLibItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public MrLibItemBuilder(ItemStack item) {
        this.item = item.clone();
        this.meta = this.item.getItemMeta();
    }

    public MrLibItemBuilder setName(String name) {
        if (this.meta != null) {
            this.meta.setDisplayName(MrLibColors.colorize(name));
        }
        return this;
    }

    public MrLibItemBuilder setName(String name, Player player) {
        if (this.meta != null) {
            this.meta.setDisplayName(MrLibColors.colorize(name, player));
        }
        return this;
    }

    public MrLibItemBuilder setLore(String ... lore) {
        if (this.meta != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                coloredLore.add(MrLibColors.colorize(line));
            }
            this.meta.setLore(coloredLore);
        }
        return this;
    }

    public MrLibItemBuilder setLore(Player player, String ... lore) {
        if (this.meta != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                coloredLore.add(MrLibColors.colorize(line, player));
            }
            this.meta.setLore(coloredLore);
        }
        return this;
    }

    public MrLibItemBuilder setLore(List<String> lore) {
        if (this.meta != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                coloredLore.add(MrLibColors.colorize(line));
            }
            this.meta.setLore(coloredLore);
        }
        return this;
    }

    public MrLibItemBuilder addLore(String ... lines) {
        if (this.meta != null) {
            List<String> lore = this.meta.hasLore() ? this.meta.getLore() : new ArrayList();
            for (String line : lines) {
                lore.add(MrLibColors.colorize(line));
            }
            this.meta.setLore(lore);
        }
        return this;
    }

    public MrLibItemBuilder setAmount(int amount) {
        this.item.setAmount(Math.max(1, Math.min(64, amount)));
        return this;
    }

    public MrLibItemBuilder addEnchant(Enchantment enchant, int level) {
        if (this.meta != null) {
            this.meta.addEnchant(enchant, level, true);
        }
        return this;
    }

    public MrLibItemBuilder addGlow() {
        if (this.meta != null) {
            this.meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public MrLibItemBuilder addFlags(ItemFlag ... flags) {
        if (this.meta != null) {
            this.meta.addItemFlags(flags);
        }
        return this;
    }

    public MrLibItemBuilder hideAllFlags() {
        if (this.meta != null) {
            this.meta.addItemFlags(ItemFlag.values());
        }
        return this;
    }

    public MrLibItemBuilder setSkullOwner(String owner) {
        if (this.meta instanceof SkullMeta) {
            ((SkullMeta)this.meta).setOwner(owner);
        }
        return this;
    }

    public MrLibItemBuilder setSkullOwner(Player player) {
        if (this.meta instanceof SkullMeta) {
            ((SkullMeta)this.meta).setOwningPlayer((OfflinePlayer)player);
        }
        return this;
    }

    public MrLibItemBuilder setCustomModelData(int data) {
        if (this.meta != null) {
            this.meta.setCustomModelData(Integer.valueOf(data));
        }
        return this;
    }

    public ItemStack build() {
        if (this.meta != null) {
            this.item.setItemMeta(this.meta);
        }
        return this.item;
    }
}

