/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibCMIHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibDecentHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.providers.MrLibNativeHologramProvider;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class MrLibHologramManager {
    private static MrLibHologramManager instance;
    private final Map<String, MrLibHologramProvider> providers = new HashMap<String, MrLibHologramProvider>();
    private MrLibHologramProvider activeProvider;

    private MrLibHologramManager() {
        this.setupProviders();
    }

    public static MrLibHologramManager getInstance() {
        if (instance == null) {
            instance = new MrLibHologramManager();
        }
        return instance;
    }

    private void setupProviders() {
        MrLibNativeHologramProvider nativeProvider = new MrLibNativeHologramProvider();
        MrLibDecentHologramProvider decentHolograms = new MrLibDecentHologramProvider();
        MrLibCMIHologramProvider cmiHolograms = new MrLibCMIHologramProvider();
        this.providers.put("MrLibCore", nativeProvider);
        this.providers.put("DecentHolograms", decentHolograms);
        this.providers.put("CMI", cmiHolograms);
        this.providers.put("CMIHolograms", cmiHolograms);
        for (MrLibHologramProvider provider : new MrLibHologramProvider[]{decentHolograms, cmiHolograms}) {
            if (!provider.isEnabled()) continue;
            this.activeProvider = provider;
            MrLibConsoleSayer.MrSay_Success("Hologram support enabled: " + provider.getProviderName());
            return;
        }
        this.activeProvider = nativeProvider;
        MrLibConsoleSayer.MrSay_Success("Hologram support enabled: MrLibCore Native (no external plugin required)");
    }

    public boolean setProvider(String providerName) {
        MrLibHologramProvider provider = this.providers.get(providerName);
        if (provider != null && provider.isEnabled()) {
            this.activeProvider = provider;
            MrLibConsoleSayer.MrSay_Success("Hologram provider set to: " + provider.getProviderName());
            return true;
        }
        MrLibConsoleSayer.MrSay_Warning("Failed to set hologram provider to: " + providerName + " (not found or disabled)");
        return false;
    }

    public boolean isEnabled() {
        return this.activeProvider != null;
    }

    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        this.activeProvider.createHologram(name, location, lines);
    }

    public void updateHologram(String name, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        this.activeProvider.updateHologram(name, lines);
    }

    public void deleteHologram(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.activeProvider.deleteHologram(name);
    }

    public void cleanupAllHolograms() {
        if (this.activeProvider instanceof MrLibNativeHologramProvider) {
            ((MrLibNativeHologramProvider)this.activeProvider).cleanupAllHolograms();
        }
    }

    public boolean hologramExists(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.activeProvider.hologramExists(name);
    }

    public String getActiveProviderName() {
        if (this.activeProvider == null) {
            return null;
        }
        return this.activeProvider.getProviderName();
    }

    public MrLibHologramProvider getActiveProvider() {
        return this.activeProvider;
    }

    public void createItemHologram(String name, Location location, ItemStack item, boolean withGlass, boolean rotate) {
        MrLibHologramProvider nativeProvider = this.providers.get("MrLibCore");
        if (nativeProvider instanceof MrLibNativeHologramProvider) {
            ((MrLibNativeHologramProvider)nativeProvider).createItemHologram(name, location, item, withGlass, rotate);
        }
    }

    public void updateItemHologram(String name, ItemStack item) {
        MrLibHologramProvider nativeProvider = this.providers.get("MrLibCore");
        if (nativeProvider instanceof MrLibNativeHologramProvider) {
            ((MrLibNativeHologramProvider)nativeProvider).updateItemHologram(name, item);
        }
    }
}

