/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.providers;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MrLibNativeHologramProvider
implements MrLibHologramProvider {
    private final Map<String, List<ArmorStand>> textHolograms = new ConcurrentHashMap<String, List<ArmorStand>>();
    private final Map<String, List<ArmorStand>> itemHolograms = new ConcurrentHashMap<String, List<ArmorStand>>();
    private final Map<String, List<String>> hologramData = new ConcurrentHashMap<String, List<String>>();
    private int rotationTaskId = -1;
    private int updateTaskId = -1;
    private Plugin plugin = Bukkit.getPluginManager().getPlugin("MrLibCore");

    public MrLibNativeHologramProvider() {
        this.startRotationTask();
    }

    @Override
    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        this.deleteHologram(name);
        if (location == null || location.getWorld() == null) {
            return;
        }
        ArrayList<ArmorStand> stands = new ArrayList<ArmorStand>();
        double yOffset = 0.0;
        for (int i = lines.size() - 1; i >= 0; --i) {
            String line = lines.get(i);
            if (line == null || line.trim().isEmpty()) continue;
            Location lineLoc = location.clone().add(0.0, yOffset, 0.0);
            ArmorStand as = (ArmorStand)location.getWorld().spawnEntity(lineLoc, EntityType.ARMOR_STAND);
            as.setMarker(true);
            as.setInvisible(true);
            as.setSmall(true);
            as.setGravity(false);
            as.setCustomName(MrLibColors.colorize(line));
            as.setCustomNameVisible(true);
            as.setMetadata("mrlib_hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)name));
            as.setMetadata("mrlib_holo_text", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
            stands.add(as);
            yOffset += 0.3;
        }
        this.textHolograms.put(name, stands);
        this.hologramData.put(name, lines);
    }

    @Override
    public void updateHologram(String name, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        List<ArmorStand> stands = this.textHolograms.get(name);
        if (stands == null || stands.isEmpty()) {
            return;
        }
        if (stands.get(0) != null && !stands.get(0).isDead()) {
            Location baseLoc = stands.get(0).getLocation();
            this.deleteHologram(name);
            this.createHologram(name, baseLoc, lines);
        }
    }

    @Override
    public void deleteHologram(String name) {
        if (!this.isEnabled()) {
            return;
        }
        List<ArmorStand> textStands = this.textHolograms.remove(name);
        if (textStands != null) {
            for (ArmorStand as : textStands) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
        }
        this.hologramData.remove(name);
        List<ArmorStand> itemStands = this.itemHolograms.remove(name);
        if (itemStands != null) {
            for (ArmorStand as : itemStands) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrlib_dropped_item")) {
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrlib_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                as.remove();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean hologramExists(String name) {
        return this.textHolograms.containsKey(name) || this.itemHolograms.containsKey(name);
    }

    @Override
    public String getProviderName() {
        return "MrLibCore";
    }

    public void createItemHologram(String name, Location location, ItemStack item, boolean withGlass, boolean rotate) {
        if (!this.isEnabled() || location == null || location.getWorld() == null || item == null) {
            return;
        }
        this.deleteHologram(name);
        ArrayList<ArmorStand> stands = new ArrayList<ArmorStand>();
        double yOffset = 1.5;
        if (withGlass) {
            Location glassLoc = location.clone().add(0.5, 0.8, 0.5);
            ArmorStand glassAs = (ArmorStand)location.getWorld().spawnEntity(glassLoc, EntityType.ARMOR_STAND);
            glassAs.setMarker(true);
            glassAs.setInvisible(true);
            glassAs.setSmall(false);
            glassAs.setGravity(false);
            glassAs.setCustomNameVisible(false);
            if (glassAs.getEquipment() != null) {
                ItemStack glassBlock = new ItemStack(Material.GLASS);
                glassAs.getEquipment().setHelmet(glassBlock);
            }
            glassAs.setMetadata("mrlib_hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)name));
            glassAs.setMetadata("mrlib_holo_glass", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
            stands.add(glassAs);
            yOffset = 2.2;
        }
        Location itemLoc = location.clone().add(0.5, yOffset, 0.5);
        ArmorStand itemAs = (ArmorStand)location.getWorld().spawnEntity(itemLoc, EntityType.ARMOR_STAND);
        itemAs.setMarker(true);
        itemAs.setInvisible(true);
        itemAs.setSmall(true);
        itemAs.setGravity(false);
        itemAs.setCustomNameVisible(false);
        itemAs.setMetadata("mrlib_hologram", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)name));
        itemAs.setMetadata("mrlib_holo_item", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        itemAs.setMetadata("mrlib_base_location", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)location));
        if (rotate) {
            itemAs.setMetadata("mrlib_rotate", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
        ItemStack displayItem = item.clone();
        displayItem.setAmount(1);
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            if (!itemAs.isDead()) {
                Item droppedItem = location.getWorld().dropItem(itemLoc, displayItem);
                droppedItem.setPickupDelay(Integer.MAX_VALUE);
                droppedItem.setVelocity(new Vector(0, 0, 0));
                droppedItem.setGravity(false);
                droppedItem.setInvulnerable(true);
                droppedItem.setMetadata("mrlib_preview_item", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
                itemAs.setMetadata("mrlib_dropped_item", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)droppedItem));
            }
        });
        stands.add(itemAs);
        this.itemHolograms.put(name, stands);
    }

    public void updateItemHologram(String name, ItemStack item) {
        if (!this.isEnabled() || item == null) {
            return;
        }
        List<ArmorStand> stands = this.itemHolograms.get(name);
        if (stands == null || stands.isEmpty()) {
            return;
        }
        for (ArmorStand as : stands) {
            if (as == null || as.isDead() || !as.hasMetadata("mrlib_holo_item")) continue;
            if (as.hasMetadata("mrlib_dropped_item")) {
                try {
                    Item oldItem = (Item)((MetadataValue)as.getMetadata("mrlib_dropped_item").get(0)).value();
                    if (oldItem != null && !oldItem.isDead()) {
                        oldItem.remove();
                    }
                }
                catch (Exception oldItem) {
                    // empty catch block
                }
            }
            ItemStack displayItem = item.clone();
            displayItem.setAmount(1);
            Location itemLoc = as.getLocation();
            Item droppedItem = as.getWorld().dropItem(itemLoc, displayItem);
            droppedItem.setPickupDelay(Integer.MAX_VALUE);
            droppedItem.setVelocity(new Vector(0, 0, 0));
            droppedItem.setGravity(false);
            droppedItem.setInvulnerable(true);
            droppedItem.setMetadata("mrlib_preview_item", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
            as.setMetadata("mrlib_dropped_item", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)droppedItem));
            break;
        }
    }

    private void startRotationTask() {
        if (this.plugin == null || this.rotationTaskId != -1) {
            return;
        }
        this.rotationTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> {
            for (List<ArmorStand> stands : this.itemHolograms.values()) {
                for (ArmorStand as : stands) {
                    if (as == null || as.isDead() || !as.hasMetadata("mrlib_holo_item") || !as.hasMetadata("mrlib_rotate") || !as.hasMetadata("mrlib_dropped_item") || !as.hasMetadata("mrlib_base_location")) continue;
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrlib_dropped_item").get(0)).value();
                        Location baseLocation = (Location)((MetadataValue)as.getMetadata("mrlib_base_location").get(0)).value();
                        if (droppedItem == null || droppedItem.isDead() || baseLocation == null) continue;
                        Location currentLoc = droppedItem.getLocation();
                        double floatOffset = Math.sin((double)System.currentTimeMillis() * 0.002) * 0.03;
                        Location newLoc = new Location(currentLoc.getWorld(), (double)baseLocation.getBlockX() + 0.5, as.getLocation().getY() + floatOffset, (double)baseLocation.getBlockZ() + 0.5, currentLoc.getYaw() + 3.0f, currentLoc.getPitch());
                        droppedItem.teleport(newLoc);
                    }
                    catch (Exception exception) {}
                }
            }
        }, 1L, 1L);
    }

    public void stopRotationTask() {
        if (this.rotationTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.rotationTaskId);
            this.rotationTaskId = -1;
        }
        if (this.updateTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.updateTaskId);
            this.updateTaskId = -1;
        }
    }

    public void removeAll() {
        for (String name : new ArrayList<String>(this.textHolograms.keySet())) {
            this.deleteHologram(name);
        }
        for (String name : new ArrayList<String>(this.itemHolograms.keySet())) {
            this.deleteHologram(name);
        }
        this.stopRotationTask();
    }

    public void cleanupAllDroppedItems() {
        for (List<ArmorStand> stands : this.itemHolograms.values()) {
            for (ArmorStand as : stands) {
                if (as == null || as.isDead() || !as.hasMetadata("mrlib_dropped_item")) continue;
                try {
                    Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrlib_dropped_item").get(0)).value();
                    if (droppedItem == null || droppedItem.isDead()) continue;
                    droppedItem.remove();
                }
                catch (Exception exception) {}
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Item item : world.getEntitiesByClass(Item.class)) {
                if (!item.hasMetadata("mrlib_preview_item")) continue;
                item.remove();
            }
        }
    }

    public void cleanupAllHolograms() {
        List<ArmorStand> stands;
        this.stopRotationTask();
        for (String name : new ArrayList<String>(this.textHolograms.keySet())) {
            stands = this.textHolograms.get(name);
            if (stands == null) continue;
            for (ArmorStand as : stands) {
                if (as == null || as.isDead()) continue;
                try {
                    as.remove();
                }
                catch (Exception exception) {}
            }
        }
        this.textHolograms.clear();
        this.hologramData.clear();
        for (String name : new ArrayList<String>(this.itemHolograms.keySet())) {
            stands = this.itemHolograms.get(name);
            if (stands == null) continue;
            for (ArmorStand as : stands) {
                if (as == null || as.isDead()) continue;
                if (as.hasMetadata("mrlib_dropped_item")) {
                    try {
                        Item droppedItem = (Item)((MetadataValue)as.getMetadata("mrlib_dropped_item").get(0)).value();
                        if (droppedItem != null && !droppedItem.isDead()) {
                            droppedItem.remove();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    as.remove();
                }
                catch (Exception exception) {}
            }
        }
        this.itemHolograms.clear();
        this.cleanupAllDroppedItems();
    }

    private void startUpdateTask() {
        if (this.plugin == null) {
            return;
        }
        this.updateTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> {
            if (!this.isEnabled()) {
                return;
            }
            for (Map.Entry<String, List<String>> entry : this.hologramData.entrySet()) {
                List<ArmorStand> existingStands;
                String name = entry.getKey();
                List<String> lines = entry.getValue();
                if (!this.textHolograms.containsKey(name) || (existingStands = this.textHolograms.get(name)).isEmpty()) continue;
                Location location = existingStands.get(0).getLocation();
                for (ArmorStand as : existingStands) {
                    if (as == null || as.isDead()) continue;
                    as.remove();
                }
                this.createHologram(name, location, lines);
            }
        }, 20L, 20L);
    }
}

