/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.utils;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibHelper {
    private static final Map<String, PluginCommandInfo> registeredPlugins = new HashMap<String, PluginCommandInfo>();
    private static final int COMMANDS_PER_PAGE = 5;

    public static String getPlayerName(Player player) {
        return player.getName();
    }

    public static void registerPluginCommands(JavaPlugin plugin, String pluginName, List<CommandInfo> commands) {
        registeredPlugins.put(pluginName, new PluginCommandInfo(plugin, pluginName, commands));
    }

    public static void showPluginHelp(Player player, String pluginName, int page) {
        PluginCommandInfo pluginInfo = registeredPlugins.get(pluginName);
        if (pluginInfo == null) {
            player.sendMessage(MrLibColors.colorize("&cPlugin " + pluginName + " is not registered!"));
            return;
        }
        List<CommandInfo> commands = pluginInfo.getCommands();
        int totalPages = (int)Math.ceil((double)commands.size() / 5.0);
        if (page < 1 || page > totalPages) {
            player.sendMessage(MrLibColors.colorize("&cInvalid page number! Available pages: 1-" + totalPages));
            return;
        }
        String header = MrLibColors.colorize("&8[&b&lMrLibCore&8] | &f" + pluginName + " - Commands. &8(&a" + page + "&8/&c" + totalPages + "&8)");
        player.sendMessage(header);
        player.sendMessage("");
        player.sendMessage(MrLibColors.colorize("&fIf you hover over the command with your mouse, an example will appear"));
        player.sendMessage("");
        int startIndex = (page - 1) * 5;
        int endIndex = Math.min(startIndex + 5, commands.size());
        for (int i = startIndex; i < endIndex; ++i) {
            CommandInfo cmd = commands.get(i);
            int commandNumber = i + 1;
            String commandText = MrLibColors.colorize("&f" + commandNumber + ". &b" + cmd.getCommand() + " &8- &f" + cmd.getDescription());
            if (cmd.getExample() != null && !cmd.getExample().isEmpty()) {
                TextComponent component = new TextComponent(commandText);
                component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)MrLibColors.colorize("&7Example: &f" + cmd.getExample()))));
                component.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, cmd.getExample()));
                player.spigot().sendMessage((BaseComponent)component);
                continue;
            }
            player.sendMessage(commandText);
        }
        player.sendMessage("");
        MrLibHelper.showNavigation(player, page, totalPages, pluginName);
    }

    private static void showNavigation(Player player, int currentPage, int totalPages, String pluginName) {
        TextComponent navigation = new TextComponent();
        if (currentPage > 1) {
            TextComponent prevButton = new TextComponent(MrLibColors.colorize("&c<<< Previous Page"));
            prevButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mvt help " + pluginName + " " + (currentPage - 1)));
            navigation.addExtra((BaseComponent)prevButton);
        } else {
            navigation.addExtra((BaseComponent)new TextComponent(MrLibColors.colorize("&8<<< Previous Page")));
        }
        navigation.addExtra((BaseComponent)new TextComponent(MrLibColors.colorize(" &8| ")));
        if (currentPage < totalPages) {
            TextComponent nextButton = new TextComponent(MrLibColors.colorize("&aNext Page >>>"));
            nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mvt help " + pluginName + " " + (currentPage + 1)));
            navigation.addExtra((BaseComponent)nextButton);
        } else {
            navigation.addExtra((BaseComponent)new TextComponent(MrLibColors.colorize("&8Next Page >>>")));
        }
        player.spigot().sendMessage((BaseComponent)navigation);
    }

    public static void showRegisteredPlugins(Player player) {
        if (registeredPlugins.isEmpty()) {
            player.sendMessage(MrLibColors.colorize("&cNo plugins registered for help system!"));
            return;
        }
        player.sendMessage(MrLibColors.colorize("&8[&b&lMrLibHelper&8] | &fAvailable plugins:"));
        for (String pluginName : registeredPlugins.keySet()) {
            TextComponent pluginButton = new TextComponent(MrLibColors.colorize("&b\u2022 " + pluginName));
            pluginButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mvt help " + pluginName + " 1"));
            pluginButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)MrLibColors.colorize("&7Click to view &b" + pluginName + " &7help"))));
            player.spigot().sendMessage((BaseComponent)pluginButton);
        }
    }

    private static class PluginCommandInfo {
        private final JavaPlugin plugin;
        private final String pluginName;
        private final List<CommandInfo> commands;

        public PluginCommandInfo(JavaPlugin plugin, String pluginName, List<CommandInfo> commands) {
            this.plugin = plugin;
            this.pluginName = pluginName;
            this.commands = commands;
        }

        public JavaPlugin getPlugin() {
            return this.plugin;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public List<CommandInfo> getCommands() {
            return this.commands;
        }
    }

    public static class CommandInfo {
        private final String command;
        private final String description;
        private final String example;

        public CommandInfo(String command, String description, String example) {
            this.command = command;
            this.description = description;
            this.example = example;
        }

        public String getCommand() {
            return this.command;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExample() {
            return this.example;
        }
    }
}

