/*
 * Decompiled with CFR 0.152.
 */
package de.survivalnight.luna.rtp.gui;

import de.survivalnight.luna.rtp.Rtp;
import de.survivalnight.luna.rtp.logic.ColorUtil;
import de.survivalnight.luna.rtp.logic.RtpManager;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RtpGui
implements Listener {
    public static void open(Player player) {
        String rawTitle = Rtp.getInstance().getConfig().getString("gui-title", "<bold><aqua>Random Teleport</bold>");
        Component titleComponent = ColorUtil.mm(rawTitle).decoration(TextDecoration.ITALIC, false);
        String legacyTitle = LegacyComponentSerializer.legacySection().serialize(titleComponent);
        int rows = Rtp.getInstance().getConfig().getInt("gui-rows", 3);
        rows = Math.max(1, Math.min(6, rows));
        int size = rows * 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)legacyTitle);
        ConfigurationSection buttons = Rtp.getInstance().getConfig().getConfigurationSection("gui");
        if (buttons != null) {
            for (String key : buttons.getKeys(false)) {
                ConfigurationSection section = buttons.getConfigurationSection(key);
                if (section == null) continue;
                Material mat = Material.matchMaterial((String)section.getString("material", "GRASS_BLOCK"));
                int slot = section.getInt("slot", 0);
                if (mat == null || slot < 0 || slot >= inv.getSize()) continue;
                ItemStack item = new ItemStack(mat);
                ItemMeta meta = item.getItemMeta();
                String name = section.getString("name", "&aTeleport");
                Component nameComponent = ColorUtil.mm(name).decoration(TextDecoration.ITALIC, false);
                meta.displayName(nameComponent);
                List lore = section.getStringList("lore");
                if (!lore.isEmpty()) {
                    List<Component> parsedLore = lore.stream().map(ColorUtil::mm).map(c -> c.decoration(TextDecoration.ITALIC, false)).toList();
                    meta.lore(parsedLore);
                }
                if (section.contains("custom-model-data")) {
                    meta.setCustomModelData(Integer.valueOf(section.getInt("custom-model-data")));
                }
                item.setItemMeta(meta);
                inv.setItem(slot, item);
            }
        }
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        String rawTitle = Rtp.getInstance().getConfig().getString("gui-title", "<bold><aqua>Random Teleport</bold>");
        Component configTitle = ColorUtil.mm(rawTitle).decoration(TextDecoration.ITALIC, false);
        String expectedTitle = LegacyComponentSerializer.legacySection().serialize(configTitle);
        if (!e.getView().getTitle().equals(expectedTitle)) {
            return;
        }
        e.setCancelled(true);
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
            return;
        }
        String legacyName = clicked.getItemMeta().getDisplayName();
        Component clickedComponent = LegacyComponentSerializer.legacySection().deserialize(legacyName).decoration(TextDecoration.ITALIC, false);
        ConfigurationSection buttons = Rtp.getInstance().getConfig().getConfigurationSection("gui");
        if (buttons == null) {
            return;
        }
        for (String key : buttons.getKeys(false)) {
            Component configComponent;
            String configName;
            ConfigurationSection sec = buttons.getConfigurationSection(key);
            if (sec == null || (configName = sec.getString("name")) == null || !clickedComponent.equals((Object)(configComponent = ColorUtil.mm(configName).decoration(TextDecoration.ITALIC, false)))) continue;
            String world = sec.getString("world");
            int range = sec.getInt("range", 1000);
            RtpManager.teleportPlayer(player, world, range);
            player.closeInventory();
            return;
        }
    }
}

